/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.colors;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.GTView;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.colors.ColorScheme;
import jhi.flapjack.gui.visualization.colors.ColorState;
import jhi.flapjack.gui.visualization.colors.HeterozygeousColorState;
import jhi.flapjack.gui.visualization.colors.HomozygousColorState;
import jhi.flapjack.gui.visualization.colors.SimpleColorState;
import scri.commons.gui.RB;

public class GenotypeFrequencyColorScheme
extends ColorScheme {
    private ArrayList<ColorState> hiStates = new ArrayList();
    private ArrayList<ColorState> loStates = new ArrayList();
    private float thresholdFrequency;

    public GenotypeFrequencyColorScheme() {
    }

    public GenotypeFrequencyColorScheme(GTView view, int w, int h) {
        super(view);
        this.thresholdFrequency = view.getViewSet().getAlleleFrequencyThreshold();
        for (int i = 0; i < this.stateTable.size(); ++i) {
            AlleleState state = this.stateTable.getAlleleState(i);
            ColorState cHi = null;
            ColorState cLo = null;
            if (state.isUnknown()) {
                cHi = cLo = new SimpleColorState(state, Prefs.visColorBackground, w, h);
            } else if (state.isHomozygous()) {
                cHi = new HomozygousColorState(state, Prefs.visColorHiFreqState, w, h);
                cLo = new HomozygousColorState(state, Prefs.visColorLoFreqState, w, h);
            } else {
                cHi = new HeterozygeousColorState(state, Prefs.visColorHiFreqState, Prefs.visColorHiFreqState, Prefs.visColorHiFreqState, w, h);
                cLo = new HeterozygeousColorState(state, Prefs.visColorLoFreqState, Prefs.visColorLoFreqState, Prefs.visColorLoFreqState, w, h);
            }
            this.hiStates.add(cHi);
            this.loStates.add(cLo);
        }
    }

    private ColorState getState(int line, int marker) {
        int state = this.view.getState(line, marker);
        if (this.view.getMarker(marker).frequencies()[state] <= this.thresholdFrequency) {
            return this.loStates.get(state);
        }
        return this.hiStates.get(state);
    }

    @Override
    public BufferedImage getSelectedImage(int line, int marker, boolean underQTL) {
        return this.getState(line, marker).getImage(underQTL);
    }

    @Override
    public BufferedImage getUnselectedImage(int line, int marker, boolean underQTL) {
        return this.getState(line, marker).getUnselectedImage(underQTL);
    }

    @Override
    public Color getColor(int line, int marker) {
        return this.getState(line, marker).getColor();
    }

    @Override
    public int getModel() {
        return 7;
    }

    public String toString() {
        return RB.getString((String)"gui.Actions.vizColorAlleleFreq");
    }

    @Override
    public String getDescription() {
        return RB.getString((String)"gui.visualization.colors.AlleleFrequencyColorScheme");
    }

    @Override
    public ArrayList<ColorScheme.ColorSummary> getColorSummaries() {
        ArrayList<ColorScheme.ColorSummary> colors = new ArrayList<ColorScheme.ColorSummary>();
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorLoFreqState, RB.getString((String)"gui.visualization.colors.AlleleFrequencyColorScheme.loFreqState")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorHiFreqState, RB.getString((String)"gui.visualization.colors.AlleleFrequencyColorScheme.hiFreqState")));
        return colors;
    }

    @Override
    public void setColorSummaries(ArrayList<ColorScheme.ColorSummary> colors) {
        Prefs.visColorLoFreqState = colors.get((int)0).color;
        Prefs.visColorHiFreqState = colors.get((int)1).color;
    }
}

