/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.SwingUtilities;
import jhi.flapjack.data.IUndoState;
import jhi.flapjack.data.MarkerInfo;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.IOverlayRenderer;
import jhi.flapjack.gui.visualization.undo.HidLinesState;
import jhi.flapjack.gui.visualization.undo.HidMarkersState;
import scri.commons.gui.RB;

class HideLMAnimator
extends Thread
implements IOverlayRenderer {
    private GenotypePanel gPanel;
    private GenotypeCanvas canvas;
    private int alphaEffect = 0;
    private int index = 0;
    private boolean isMarkerIndex;

    HideLMAnimator(GenotypePanel gPanel, int index, boolean isMarkerIndex) {
        this.gPanel = gPanel;
        this.index = index;
        this.isMarkerIndex = isMarkerIndex;
        this.canvas = gPanel.canvas;
        this.start();
    }

    @Override
    public void run() {
        IUndoState state;
        for (IOverlayRenderer r : this.canvas.overlays) {
            if (!(r instanceof HideLMAnimator)) continue;
            return;
        }
        this.canvas.resetBufferedState(false);
        this.canvas.overlays.add(this);
        for (int i = 1; i <= 20; ++i) {
            this.alphaEffect = (int)((double)i * 12.75);
            this.canvas.repaint();
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException r) {
                // empty catch block
            }
        }
        if (this.isMarkerIndex) {
            state = new HidMarkersState(this.canvas.view, RB.getString((String)"gui.visualization.HidMarkersState.hidMarkers"));
            ((HidMarkersState)state).createUndoState();
            MarkerInfo mi = this.canvas.view.getMarkers().get(this.index);
            this.canvas.view.hideMarker(mi);
            this.canvas.overlays.remove(this);
            ((HidMarkersState)state).createRedoState();
            this.gPanel.addUndoState(state);
        } else {
            state = new HidLinesState(this.canvas.viewSet, RB.getString((String)"gui.visualization.HidLinesState.hidLines"));
            ((HidLinesState)state).createUndoState();
            this.canvas.view.hideLine(this.index);
            this.canvas.overlays.remove(this);
            ((HidLinesState)state).createRedoState();
            this.gPanel.addUndoState(state);
        }
        Runnable r = () -> this.gPanel.refreshView();
        SwingUtilities.invokeLater(r);
    }

    @Override
    public void render(Graphics2D g) {
        g.setPaint(new Color(255, 255, 255, this.alphaEffect));
        if (this.isMarkerIndex) {
            int mX = this.canvas.boxW * this.index;
            g.fillRect(mX, 0, this.canvas.boxW, this.canvas.canvasH);
        } else {
            int mY = this.canvas.boxH * this.index;
            g.fillRect(0, mY, this.canvas.canvasW, this.canvas.boxH);
        }
    }
}

