/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.GenotypeCanvas;

class ColCanvas
extends JPanel {
    private GenotypeCanvas canvas;
    private int markerIndex = -1;
    private int lineIndex;
    private int lineCount;
    private int colW = 15;
    private int w = 45;

    ColCanvas(GenotypeCanvas canvas) {
        this.canvas = canvas;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(1, 5, 0, 5));
        this.add(new Canvas2D());
    }

    void updateOverviewSelectionBox(int lineIndex, int lineCount) {
        this.lineIndex = lineIndex;
        this.lineCount = lineCount;
        this.repaint();
    }

    void setMarkerIndex(int markerIndex) {
        if (this.markerIndex != markerIndex && !this.canvas.locked) {
            this.markerIndex = markerIndex;
            this.repaint();
        }
    }

    private class Canvas2D
    extends JPanel {
        Canvas2D() {
            this.setPreferredSize(new Dimension(ColCanvas.this.w, 0));
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D g = (Graphics2D)graphics;
            int height = ((ColCanvas)ColCanvas.this).canvas.pY2 - ((ColCanvas)ColCanvas.this).canvas.pY1 + 1;
            g.setColor(Prefs.visColorBackground);
            g.fillRect(0, 0, ColCanvas.this.w, height);
            if (ColCanvas.this.markerIndex < 0 || ColCanvas.this.markerIndex >= ((ColCanvas)ColCanvas.this).canvas.view.markerCount()) {
                return;
            }
            float yScale = (float)((ColCanvas)ColCanvas.this).canvas.boxTotalY / (float)height;
            for (int y = 0; y < height; ++y) {
                int rowIndex = (int)(yScale * (float)y);
                int x = 0;
                int xIndex = ColCanvas.this.markerIndex - 1;
                while (xIndex < ColCanvas.this.markerIndex + 2) {
                    if (xIndex >= 0 && xIndex < ((ColCanvas)ColCanvas.this).canvas.view.markerCount()) {
                        g.setColor(((ColCanvas)ColCanvas.this).canvas.cScheme.getColor(rowIndex, xIndex));
                        g.fillRect(x, y, ColCanvas.this.w / 3, 1);
                    }
                    ++xIndex;
                    x += ColCanvas.this.colW;
                }
            }
            yScale = (float)height / (float)((ColCanvas)ColCanvas.this).canvas.boxTotalY;
            float y1 = (float)ColCanvas.this.lineIndex * yScale;
            float y2 = y1 + (float)ColCanvas.this.lineCount * yScale;
            if (ColCanvas.this.lineCount > ((ColCanvas)ColCanvas.this).canvas.boxTotalY || y2 >= (float)height) {
                y2 = height - 1;
            }
            int cR = Prefs.visColorOverviewFill.getRed();
            int cG = Prefs.visColorOverviewFill.getGreen();
            int cB = Prefs.visColorOverviewFill.getBlue();
            g.setPaint(new Color(cR, cG, cB, 50));
            g.fillRect(0, Math.round(y1), ColCanvas.this.w - 1, Math.round(y2 - y1));
            g.setColor(Prefs.visColorOverviewOutline);
            g.drawRect(0, Math.round(y1), ColCanvas.this.w - 1, Math.round(y2 - y1));
        }
    }
}

