/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.WinMain;
import jhi.flapjack.gui.visualization.CanvasController;
import jhi.flapjack.gui.visualization.CanvasMenu;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import jhi.flapjack.gui.visualization.GenotypeCanvasInfoPane;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.GraphCanvas;
import jhi.flapjack.gui.visualization.HideLMAnimator;
import jhi.flapjack.gui.visualization.MineSweeper;
import jhi.flapjack.gui.visualization.OverviewManager;
import jhi.flapjack.gui.visualization.undo.MovedLinesState;
import jhi.flapjack.gui.visualization.undo.MovedMarkersState;
import jhi.flapjack.gui.visualization.undo.SelectedLinesState;
import jhi.flapjack.gui.visualization.undo.SelectedMarkersState;
import scri.commons.gui.RB;
import scri.commons.gui.SystemUtils;

class CanvasMouseListener
extends MouseInputAdapter {
    private GenotypePanel gPanel;
    private GenotypeCanvas canvas;
    private CanvasMenu canvasMenu;
    private GenotypeCanvasInfoPane infoPane;
    private InteractiveHandler iHandler = new InteractiveHandler();
    private NavigationHandler nHandler = new NavigationHandler();
    private MarkerSelectionHandler mrkrSelHandler = new MarkerSelectionHandler();
    private LineSelectionHandler lineSelHandler = new LineSelectionHandler();
    private boolean isOSX = SystemUtils.isMacOS();

    CanvasMouseListener(GenotypePanel gPanel, GenotypeCanvas canvas, WinMain winMain) {
        this.gPanel = gPanel;
        this.canvas = canvas;
        this.canvasMenu = new CanvasMenu(canvas, winMain);
        this.infoPane = new GenotypeCanvasInfoPane(gPanel, canvas);
        canvas.addMouseListener(this);
        canvas.addMouseMotionListener(this);
        canvas.addMouseWheelListener(this);
    }

    private boolean isMetaClick(MouseEvent e) {
        return this.isOSX && e.isMetaDown() || !this.isOSX && e.isControlDown();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        if (this.isMetaClick(e) && e.isAltDown() && e.getClickCount() == 2) {
            this.canvas.removeMouseListener(this);
            new MineSweeper(this.canvas, this);
        } else if (this.isMetaClick(e) && e.getClickCount() == 2 && Prefs.guiMouseMode == 1) {
            int markerIndex = this.canvas.getMarker(e.getPoint());
            new HideLMAnimator(this.gPanel, markerIndex, true);
        } else if (this.isMetaClick(e) && e.getClickCount() == 2 && Prefs.guiMouseMode == 2) {
            int lineIndex = this.canvas.getLine(e.getPoint());
            new HideLMAnimator(this.gPanel, lineIndex, false);
        } else if (e.getClickCount() == 2) {
            this.gPanel.getController().clickZoom(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.canvas.overlays.remove(this.canvas.crosshair);
        this.canvas.repaint();
        if (e.isPopupTrigger()) {
            this.canvasMenu.handlePopup(e);
        }
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (this.isMetaClick(e)) {
                this.iHandler.mousePressed(e);
            } else if (Prefs.guiMouseMode == 0) {
                this.nHandler.mousePressed(e);
            } else if (Prefs.guiMouseMode == 1) {
                this.mrkrSelHandler.mousePressed(e);
            } else if (Prefs.guiMouseMode == 2) {
                this.lineSelHandler.mousePressed(e);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.canvas.overlays.contains(this.canvas.crosshair)) {
            this.canvas.overlays.add(this.canvas.crosshair);
            this.canvas.repaint();
        }
        if (e.isPopupTrigger()) {
            this.canvasMenu.handlePopup(e);
        }
        this.nHandler.mouseReleased(e);
        this.iHandler.mouseReleased(e);
        this.mrkrSelHandler.mouseReleased(e);
        this.lineSelHandler.mouseReleased(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.nHandler.mouseDragged(e);
        if (this.isMetaClick(e)) {
            this.iHandler.mouseDragged(e);
        } else if (Prefs.guiMouseMode == 1) {
            this.mrkrSelHandler.mouseDragged(e);
        } else if (Prefs.guiMouseMode == 2) {
            this.lineSelHandler.mouseDragged(e);
        }
        this.mouseMoved(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int xIndex = this.canvas.getMarker(e.getPoint());
        int yIndex = this.canvas.getLine(e.getPoint());
        if (!this.canvasMenu.isShowingMenu()) {
            this.gPanel.overRow(xIndex, yIndex);
        }
        this.infoPane.setMousePosition(e.getPoint());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.gPanel.statusPanel.setForMainUse();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.canvasMenu.isShowingMenu()) {
            this.gPanel.overRow(-1, -1);
        }
        this.infoPane.setMousePosition(null);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int shortcut = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (e.getModifiers() == shortcut && Prefs.visLinkSliders) {
            int currentValue = this.gPanel.statusPanel.getZoomY();
            this.gPanel.statusPanel.setZoomY(currentValue - e.getWheelRotation());
        } else {
            CanvasController controller = this.gPanel.getController();
            JScrollBar sBar = null;
            if (controller.getVBar().isVisible()) {
                sBar = controller.getVBar();
            } else if (controller.getHBar().isVisible()) {
                sBar = controller.getHBar();
            }
            if (sBar != null) {
                int notches = e.getWheelRotation();
                int value = sBar.getValue();
                int units = 5 * sBar.getUnitIncrement();
                sBar.setValue(value + notches * units);
            }
        }
    }

    private class LineSelectionHandler {
        private int selectedLine = -1;
        private int firstSelected = -1;
        private boolean selectionState;
        private SelectedLinesState lineStates;

        private LineSelectionHandler() {
        }

        void mousePressed(MouseEvent e) {
            int index = CanvasMouseListener.this.canvas.getLine(e.getPoint());
            if (index < 0 || index > ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.lineCount()) {
                return;
            }
            this.lineStates = new SelectedLinesState(((CanvasMouseListener)CanvasMouseListener.this).canvas.view, RB.getString((String)"gui.visualization.SelectedLinesState.selected"));
            this.lineStates.createUndoState();
            this.firstSelected = this.selectedLine = index;
            this.selectionState = ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.toggleLineState(this.selectedLine);
            CanvasMouseListener.this.canvas.resetBufferedState(false);
        }

        void mouseReleased(MouseEvent e) {
            if (this.selectedLine == -1) {
                return;
            }
            this.selectedLine = -1;
            CanvasMouseListener.this.canvas.resetBufferedState(true);
            this.lineStates.createRedoState();
            CanvasMouseListener.this.gPanel.addUndoState(this.lineStates);
        }

        void mouseDragged(MouseEvent e) {
            int x = e.getPoint().x;
            int y = e.getPoint().y;
            if (this.selectedLine != -1) {
                int newLine = CanvasMouseListener.this.canvas.getLine(e.getPoint());
                if (newLine < 0) {
                    newLine = 0;
                } else if (newLine >= ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.lineCount()) {
                    newLine = ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.lineCount() - 1;
                }
                if (newLine != this.selectedLine) {
                    if (newLine < this.selectedLine) {
                        for (int i = this.selectedLine; i >= newLine; --i) {
                            if (i <= this.firstSelected) {
                                ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.setLineState(i, this.selectionState);
                                continue;
                            }
                            ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.setLineState(i, !this.selectionState);
                        }
                    } else if (newLine > this.selectedLine) {
                        for (int i = this.selectedLine; i <= newLine; ++i) {
                            if (i >= this.firstSelected) {
                                ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.setLineState(i, this.selectionState);
                                continue;
                            }
                            ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.setLineState(i, !this.selectionState);
                        }
                    }
                    this.selectedLine = newLine;
                    CanvasMouseListener.this.canvas.resetBufferedState(false);
                    CanvasMouseListener.this.canvas.scrollRectToVisible(new Rectangle(x - 5, y - 5, 10, 10));
                }
            }
        }
    }

    private class MarkerSelectionHandler {
        private int selectedMarker = -1;
        private int firstSelected = -1;
        private boolean selectionState;
        private SelectedMarkersState markerStates;

        private MarkerSelectionHandler() {
        }

        void mousePressed(MouseEvent e) {
            int index = CanvasMouseListener.this.canvas.getMarker(e.getPoint());
            if (index < 0 || index > ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.markerCount()) {
                return;
            }
            this.markerStates = new SelectedMarkersState(((CanvasMouseListener)CanvasMouseListener.this).canvas.view, RB.getString((String)"gui.visualization.SelectedMarkersState.selected"));
            this.markerStates.createUndoState();
            this.firstSelected = this.selectedMarker = index;
            this.selectionState = ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.toggleMarkerState(this.selectedMarker);
            CanvasMouseListener.this.canvas.resetBufferedState(false);
        }

        void mouseReleased(MouseEvent e) {
            if (this.selectedMarker == -1) {
                return;
            }
            this.selectedMarker = -1;
            CanvasMouseListener.this.canvas.resetBufferedState(true);
            this.markerStates.createRedoState();
            CanvasMouseListener.this.gPanel.addUndoState(this.markerStates);
        }

        void mouseDragged(MouseEvent e) {
            int x = e.getPoint().x;
            int y = e.getPoint().y;
            if (this.selectedMarker != -1) {
                int newMarker = CanvasMouseListener.this.canvas.getMarker(e.getPoint());
                if (newMarker < 0) {
                    newMarker = 0;
                } else if (newMarker >= ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.markerCount()) {
                    newMarker = ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.markerCount() - 1;
                }
                if (newMarker != this.selectedMarker) {
                    if (newMarker < this.selectedMarker) {
                        for (int i = this.selectedMarker; i >= newMarker; --i) {
                            if (i <= this.firstSelected) {
                                ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.setMarkerState(i, this.selectionState);
                                continue;
                            }
                            ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.setMarkerState(i, !this.selectionState);
                        }
                    } else if (newMarker > this.selectedMarker) {
                        for (int i = this.selectedMarker; i <= newMarker; ++i) {
                            if (i >= this.firstSelected) {
                                ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.setMarkerState(i, this.selectionState);
                                continue;
                            }
                            ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.setMarkerState(i, !this.selectionState);
                        }
                    }
                    this.selectedMarker = newMarker;
                    CanvasMouseListener.this.canvas.resetBufferedState(false);
                    CanvasMouseListener.this.canvas.scrollRectToVisible(new Rectangle(x - 5, y - 5, 10, 10));
                }
            }
        }
    }

    private class NavigationHandler {
        private Point dragPoint;

        private NavigationHandler() {
        }

        void mousePressed(MouseEvent e) {
            this.dragPoint = e.getPoint();
        }

        void mouseReleased(MouseEvent e) {
            this.dragPoint = null;
            CanvasMouseListener.this.canvas.setCursor(new Cursor(0));
        }

        void mouseDragged(MouseEvent e) {
            if (this.dragPoint != null) {
                CanvasMouseListener.this.canvas.setCursor(new Cursor(12));
                int diffX = this.dragPoint.x - e.getPoint().x;
                int diffY = this.dragPoint.y - e.getPoint().y;
                CanvasMouseListener.this.gPanel.getController().moveBy(diffX, diffY);
            }
        }
    }

    private class InteractiveHandler {
        private boolean isLineMoving = false;
        private int selectedLine = -1;
        private boolean isMarkerMoving = false;
        private int selectedMarker = -1;
        private MovedLinesState movedLinesState;
        private MovedMarkersState movedMarkersState;

        private InteractiveHandler() {
        }

        void mousePressed(MouseEvent e) {
            this.selectedLine = e.getY() / ((CanvasMouseListener)CanvasMouseListener.this).canvas.boxH;
            this.selectedMarker = e.getX() / ((CanvasMouseListener)CanvasMouseListener.this).canvas.boxW;
            if (((CanvasMouseListener)CanvasMouseListener.this).canvas.view.getMarker(this.selectedMarker).dummyMarker()) {
                this.selectedMarker = -1;
            } else {
                this.movedMarkersState = new MovedMarkersState(((CanvasMouseListener)CanvasMouseListener.this).canvas.view, RB.getString((String)"gui.visualization.MovedMarkersState.movedMarkers"));
                this.movedMarkersState.createUndoState();
            }
            this.movedLinesState = new MovedLinesState(((CanvasMouseListener)CanvasMouseListener.this).canvas.viewSet, RB.getString((String)"gui.visualization.MovedLinesState.movedLines"));
            this.movedLinesState.createUndoState();
        }

        void mouseReleased(MouseEvent e) {
            if (this.isLineMoving || this.isMarkerMoving) {
                if (this.isLineMoving) {
                    this.movedLinesState.createRedoState();
                    CanvasMouseListener.this.gPanel.addUndoState(this.movedLinesState);
                }
                if (this.isMarkerMoving) {
                    this.movedMarkersState.createRedoState();
                    CanvasMouseListener.this.gPanel.addUndoState(this.movedMarkersState);
                    ((CanvasMouseListener)CanvasMouseListener.this).gPanel.mapCanvas.updateBuffer = true;
                    for (GraphCanvas gc : ((CanvasMouseListener)CanvasMouseListener.this).gPanel.graphCanvas) {
                        gc.updateBuffer = true;
                    }
                    ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.setMarkersOrdered(false);
                }
                this.isMarkerMoving = false;
                this.isLineMoving = false;
                this.selectedMarker = -1;
                this.selectedLine = -1;
                OverviewManager.createImage();
                CanvasMouseListener.this.canvas.resetBufferedState(true);
            }
        }

        void mouseDragged(MouseEvent e) {
            int i;
            int x = e.getPoint().x;
            int y = e.getPoint().y;
            if (this.selectedLine != -1 && !this.isMarkerMoving) {
                int newLine = y / ((CanvasMouseListener)CanvasMouseListener.this).canvas.boxH;
                if (newLine < 0) {
                    newLine = 0;
                } else if (newLine >= ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.lineCount()) {
                    newLine = ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.lineCount() - 1;
                }
                if (newLine != this.selectedLine) {
                    if (newLine < this.selectedLine) {
                        for (i = this.selectedLine; i > newLine; --i) {
                            ((CanvasMouseListener)CanvasMouseListener.this).canvas.viewSet.moveLine(i, i - 1);
                            ((CanvasMouseListener)CanvasMouseListener.this).gPanel.listPanel.moveLine(i, i - 1);
                        }
                    } else if (newLine > this.selectedLine) {
                        for (i = this.selectedLine; i < newLine; ++i) {
                            ((CanvasMouseListener)CanvasMouseListener.this).canvas.viewSet.moveLine(i, i + 1);
                            ((CanvasMouseListener)CanvasMouseListener.this).gPanel.listPanel.moveLine(i, i + 1);
                        }
                    }
                    this.selectedLine = newLine;
                    CanvasMouseListener.this.canvas.resetBufferedState(false);
                    CanvasMouseListener.this.canvas.scrollRectToVisible(new Rectangle(x - 5, y - 5, 10, 10));
                    this.isLineMoving = true;
                }
            }
            if (this.selectedMarker != -1 && !this.isLineMoving) {
                int newMarker = x / ((CanvasMouseListener)CanvasMouseListener.this).canvas.boxW;
                if (newMarker < 0) {
                    newMarker = 0;
                } else if (newMarker >= ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.markerCount()) {
                    newMarker = ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.markerCount() - 1;
                }
                if (newMarker != this.selectedMarker) {
                    if (newMarker < this.selectedMarker) {
                        for (i = this.selectedMarker; i > newMarker; --i) {
                            ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.moveMarker(i, i - 1);
                        }
                    } else if (newMarker > this.selectedMarker) {
                        for (i = this.selectedMarker; i < newMarker; ++i) {
                            ((CanvasMouseListener)CanvasMouseListener.this).canvas.view.moveMarker(i, i + 1);
                        }
                    }
                    this.selectedMarker = newMarker;
                    CanvasMouseListener.this.canvas.resetBufferedState(false);
                    for (GraphCanvas gc : ((CanvasMouseListener)CanvasMouseListener.this).gPanel.graphCanvas) {
                        gc.updateBuffer = true;
                        gc.repaint();
                    }
                    CanvasMouseListener.this.canvas.scrollRectToVisible(new Rectangle(x - 5, y - 5, 10, 10));
                    this.isMarkerMoving = true;
                }
            }
        }
    }
}

