/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.simmatrix;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.math.BigDecimal;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jhi.flapjack.data.results.SimMatrix;
import jhi.flapjack.gui.simmatrix.SimMatrixGraphPanelNB;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.statistics.SimpleHistogramBin;
import org.jfree.data.statistics.SimpleHistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class SimMatrixGraphPanel
extends JPanel {
    private SimMatrix matrix;
    private JFreeChart chart;
    private SimMatrixGraphPanelNB controls;

    SimMatrixGraphPanel(SimMatrix matrix) {
        this.matrix = matrix;
        this.controls = new SimMatrixGraphPanelNB(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.controls, "South");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SimMatrixGraphPanel.this.initData();
            }
        });
    }

    void initData() {
        SimpleHistogramDataset dataset = new SimpleHistogramDataset((Comparable)((Object)"Series 1"));
        long s = System.currentTimeMillis();
        int numBins = this.controls.getNumBins();
        BigDecimal binSize = BigDecimal.valueOf(1.0 / (double)numBins);
        System.out.println("binSize: " + binSize);
        for (int i = 0; i < numBins; ++i) {
            BigDecimal b1 = binSize.multiply(BigDecimal.valueOf(i));
            BigDecimal b2 = b1.add(binSize);
            boolean includeUpperBound = i == numBins - 1;
            dataset.addBin(new SimpleHistogramBin(b1.doubleValue(), b2.doubleValue(), true, includeUpperBound));
        }
        int size = this.matrix.size();
        System.out.println("size is " + size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (j <= i) {
                    dataset.addObservation((double)this.matrix.valueAt(i, j));
                    continue;
                }
                dataset.addObservation((double)this.matrix.valueAt(j, i));
            }
        }
        long e = System.currentTimeMillis();
        System.out.println("Chart (data) creation time: " + (e - s) + " ms");
        this.chart = this.createChart((IntervalXYDataset)dataset);
        ChartPanel panel = new ChartPanel(this.chart);
        this.add((Component)panel);
    }

    private void setChartData(double[][] data) {
        XYSeries series = new XYSeries((Comparable)((Object)""));
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                series.add(data[i][0], data[i][1]);
            }
        }
        XYSeriesCollection coll = new XYSeriesCollection(series);
        this.chart.getXYPlot().setDataset((XYDataset)coll);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        ValueAxis range = plot.getRangeAxis();
        range.setVisible(true);
        range = plot.getDomainAxis();
    }

    private JFreeChart createChart(IntervalXYDataset dataset) {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart chart = ChartFactory.createHistogram(null, null, null, (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        chart.setRenderingHints(rh);
        chart.removeLegend();
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinePaint((Paint)Color.GRAY);
        plot.setRangeGridlinePaint((Paint)Color.GRAY);
        NumberAxis xAxis = (NumberAxis)plot.getDomainAxis();
        NumberAxis yAxis = (NumberAxis)plot.getRangeAxis();
        yAxis.setTickLabelFont(new JLabel().getFont());
        return chart;
    }
}

