/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.simmatrix;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;
import jhi.flapjack.gui.simmatrix.CanvasController;
import jhi.flapjack.gui.simmatrix.SimMatrixCanvas;
import jhi.flapjack.gui.simmatrix.SimMatrixPanel;

class SimMatrixCanvasML
extends MouseInputAdapter {
    private SimMatrixPanel sPanel;
    private CanvasController controller;
    private SimMatrixCanvas sCanvas;
    private Point dragPoint;

    SimMatrixCanvasML(SimMatrixPanel sPanel, CanvasController controller) {
        this.sPanel = sPanel;
        this.controller = controller;
        this.sCanvas = sPanel.getSimMatrixCanvas();
        this.sCanvas.addMouseListener(this);
        this.sCanvas.addMouseMotionListener(this);
        this.sCanvas.addMouseWheelListener(this);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dragPoint = e.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dragPoint = null;
        this.sCanvas.setCursor(new Cursor(0));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.dragPoint != null) {
            this.sCanvas.setCursor(new Cursor(12));
            int diffX = this.dragPoint.x - e.getPoint().x;
            int diffY = this.dragPoint.y - e.getPoint().y;
            this.controller.moveBy(diffX, diffY);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 1) {
            System.out.println("Over box X: " + e.getX() / this.sCanvas.boxW + " Y: " + e.getY() / this.sCanvas.boxH);
        }
        if (e.getClickCount() == 2) {
            this.sPanel.getController().clickZoom(e);
        }
    }
}

