/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.importer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.dialog.importer.ImportBrapiTabNB;
import jhi.flapjack.gui.dialog.importer.ImportFeaturesTabNB;
import jhi.flapjack.gui.dialog.importer.ImportGenoTabNB;
import jhi.flapjack.gui.dialog.importer.ImportGraphTabNB;
import jhi.flapjack.gui.dialog.importer.ImportSampleTabNB;
import jhi.flapjack.gui.dialog.importer.ImportTraitsTabNB;
import jhi.flapjack.io.FlapjackFile;
import scri.commons.gui.Icons;
import scri.commons.gui.RB;
import scri.commons.gui.matisse.DialogPanel;

public class ImportDialog
extends JDialog
implements ActionListener,
ChangeListener {
    private JButton bImport;
    private JButton bCancel;
    private JButton bHelp;
    private boolean isOK = false;
    private JTabbedPane tabs;
    private boolean secondaryOptions;
    private ImportBrapiTabNB brapiTab;
    private ImportGenoTabNB genoTab;
    private ImportTraitsTabNB traitsTab;
    private ImportFeaturesTabNB featuresTab;
    private ImportGraphTabNB graphsTab;
    private ImportSampleTabNB sampleTab;

    public ImportDialog(int tabIndex, boolean secondaryOptions) {
        super(Flapjack.winMain, RB.getString((String)"gui.dialog.DataImportDialog.title"), true);
        this.secondaryOptions = secondaryOptions;
        this.add((Component)this.createButtons(tabIndex), "South");
        this.tabs = new JTabbedPane();
        this.brapiTab = new ImportBrapiTabNB();
        this.tabs.addTab(RB.getString((String)"gui.dialog.DataImportDialog.brapiTab"), Icons.getIcon((String)"BRAPI16"), this.brapiTab);
        this.genoTab = new ImportGenoTabNB(this);
        this.tabs.addTab(RB.getString((String)"gui.dialog.DataImportDialog.dataTab"), Icons.getIcon((String)"DATATAB"), this.genoTab);
        this.traitsTab = new ImportTraitsTabNB(secondaryOptions);
        this.tabs.addTab(RB.getString((String)"gui.dialog.DataImportDialog.phenotypesTab"), Icons.getIcon((String)"PHENOTYPETAB"), this.traitsTab);
        this.featuresTab = new ImportFeaturesTabNB(secondaryOptions);
        this.tabs.addTab(RB.getString((String)"gui.dialog.DataImportDialog.featuresTab"), Icons.getIcon((String)"QTLTAB"), this.featuresTab);
        this.graphsTab = new ImportGraphTabNB(secondaryOptions);
        this.tabs.addTab(RB.getString((String)"gui.dialog.DataImportDialog.graphTab"), Icons.getIcon((String)"GRAPHTAB"), this.graphsTab);
        this.sampleTab = new ImportSampleTabNB(this.bImport);
        this.tabs.addTab(RB.getString((String)"gui.dialog.DataImportDialog.sampleTab"), Icons.getIcon((String)"HELPTAB"), this.sampleTab);
        this.tabs.addChangeListener(this);
        this.tabs.setSelectedIndex(tabIndex);
        this.add(this.tabs);
        FlapjackUtils.initDialog(this, this.bImport, this.bCancel, true, this.getContentPane());
    }

    private JPanel createButtons(int tabIndex) {
        this.bImport = tabIndex == 0 ? new JButton(RB.getString((String)"gui.dialog.DataImportDialog.importBrapi")) : new JButton(RB.getString((String)"gui.dialog.DataImportDialog.import"));
        this.bImport.addActionListener(this);
        this.bCancel = new JButton(RB.getString((String)"gui.text.cancel"));
        this.bCancel.addActionListener(this);
        this.bHelp = new JButton(RB.getString((String)"gui.text.help"));
        RB.setText((AbstractButton)this.bHelp, (String)"gui.text.help");
        FlapjackUtils.setHelp(this.bHelp, "import_data.html");
        DialogPanel p1 = new DialogPanel();
        p1.add(this.bImport);
        p1.add(this.bCancel);
        p1.add(this.bHelp);
        return p1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bImport) {
            switch (this.tabs.getSelectedIndex()) {
                case 1: {
                    if (this.genoTab.isOK()) break;
                    return;
                }
                case 2: {
                    if (this.traitsTab.isOK()) break;
                    return;
                }
                case 3: {
                    if (this.featuresTab.isOK()) break;
                    return;
                }
                case 4: {
                    if (this.graphsTab.isOK()) break;
                    return;
                }
            }
            this.isOK = true;
            this.setVisible(false);
        } else if (e.getSource() == this.bCancel) {
            this.setVisible(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        switch (this.tabs.getSelectedIndex()) {
            case 0: {
                RB.setText((AbstractButton)this.bImport, (String)"gui.dialog.DataImportDialog.importBrapi");
                this.bImport.setEnabled(true);
                break;
            }
            case 1: {
                RB.setText((AbstractButton)this.bImport, (String)"gui.dialog.DataImportDialog.import");
                this.bImport.setEnabled(true);
                break;
            }
            case 2: {
                RB.setText((AbstractButton)this.bImport, (String)"gui.dialog.DataImportDialog.importPhenotypes");
                this.bImport.setEnabled(this.secondaryOptions);
                break;
            }
            case 3: {
                RB.setText((AbstractButton)this.bImport, (String)"gui.dialog.DataImportDialog.importFeatures");
                this.bImport.setEnabled(this.secondaryOptions);
                break;
            }
            case 4: {
                RB.setText((AbstractButton)this.bImport, (String)"gui.dialog.DataImportDialog.importGraphs");
                this.bImport.setEnabled(this.secondaryOptions);
                break;
            }
            case 5: {
                RB.setText((AbstractButton)this.bImport, (String)"gui.dialog.DataImportDialog.importSample");
                this.bImport.setEnabled(this.sampleTab.isOK());
            }
        }
    }

    public boolean isOK() {
        return this.isOK;
    }

    public int getSelectedAction() {
        return this.tabs.getSelectedIndex();
    }

    public File getMapFile() {
        return this.genoTab.getMapFile();
    }

    public File getGenotypeFile() {
        return this.genoTab.getGenotypeFile();
    }

    public File getHDF5File() {
        return this.genoTab.getHDF5File();
    }

    public File getTraitsFile() {
        return this.traitsTab.getFile();
    }

    public File getFeaturesFile() {
        return this.featuresTab.getFile();
    }

    public File getGraphsFile() {
        return this.graphsTab.getFile();
    }

    public FlapjackFile getSampleProject() {
        return this.sampleTab.getProject();
    }
}

