/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.analysis;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import jhi.flapjack.analysis.AnalysisSet;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import scri.commons.gui.RB;
import scri.commons.gui.matisse.DialogPanel;
import scri.commons.gui.matisse.HyperLinkLabel;

public class ChromosomeSelectionDialog
extends JDialog
implements ActionListener {
    private ChromosomeSelectionTableModel model;
    private boolean hideAllChrs;
    private JButton bClose;
    private JTable chromosomesTable;
    private DialogPanel dialogPanel1;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JLabel lblMarkersFromChr;
    private JLabel lblPipe;
    private JLabel lblSelectedLines;
    private HyperLinkLabel selectAllLabel;
    private HyperLinkLabel selectNoneLabel;

    public ChromosomeSelectionDialog(GTViewSet viewSet, boolean hideAllChrs) {
        super(Flapjack.winMain, RB.getString((String)"gui.dialog.analysis.ChromosomeSelectionDialog.title"), true);
        this.hideAllChrs = hideAllChrs;
        this.initComponents();
        this.initComponents2(viewSet);
        FlapjackUtils.initDialog(this, this.bClose, this.bClose, false, this.getContentPane());
    }

    private void initComponents2(GTViewSet viewSet) {
        this.bClose.addActionListener(this);
        this.selectAllLabel.addActionListener((ActionListener)this);
        this.selectNoneLabel.addActionListener((ActionListener)this);
        AnalysisSet allLines = new AnalysisSet(viewSet);
        allLines.withAllLines();
        AnalysisSet selectedLines = new AnalysisSet(viewSet);
        selectedLines.withSelectedLines();
        this.lblSelectedLines.setText(RB.format((String)"gui.dialog.analysis.ChromosomeSelectionDialog.lblSelectedLines", (Object[])new Object[]{selectedLines.lineCount(), allLines.lineCount()}));
        RB.setText((JLabel)this.lblMarkersFromChr, (String)"gui.dialog.analysis.ChromosomeSelectionDialog.lblMarkersFromChr");
        RB.setText((JLabel)this.selectAllLabel, (String)"gui.dialog.analysis.ChromosomeSelectionDialog.selectAll");
        RB.setText((JLabel)this.selectNoneLabel, (String)"gui.dialog.analysis.ChromosomeSelectionDialog.selectNone");
        AnalysisSet allMarkers = new AnalysisSet(viewSet);
        allMarkers.withViews(null);
        allMarkers.withAllMarkers();
        AnalysisSet selectedMarkers = new AnalysisSet(viewSet);
        selectedMarkers.withViews(null);
        selectedMarkers.withSelectedMarkers();
        ArrayList<String> markerSelectionValues = new ArrayList<String>();
        ArrayList<ChromosomeMap> maps = new ArrayList<ChromosomeMap>();
        for (int i = 0; i < allMarkers.viewCount(); ++i) {
            markerSelectionValues.add(selectedMarkers.markerCount(i) + "/" + allMarkers.markerCount(i));
            maps.add(allMarkers.getGTView(i).getChromosomeMap());
        }
        this.model = new ChromosomeSelectionTableModel(maps, markerSelectionValues);
        this.chromosomesTable.setModel(this.model);
        this.chromosomesTable.getColumnModel().getColumn(0).setPreferredWidth(20);
    }

    public void hideLineSummary() {
        this.lblSelectedLines.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block3: {
            block4: {
                block2: {
                    if (e.getSource() != this.bClose) break block2;
                    this.setVisible(false);
                    break block3;
                }
                if (e.getSource() != this.selectAllLabel) break block4;
                for (int i = 0; i < this.model.getRowCount(); ++i) {
                    if (!this.model.isCellEditable(i, 0)) continue;
                    this.model.setValueAt(true, i, 0);
                }
                break block3;
            }
            if (e.getSource() != this.selectNoneLabel) break block3;
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                this.model.setValueAt(false, i, 0);
            }
        }
    }

    public boolean[] getSelectedChromosomes() {
        this.model.updateForFinalSelection();
        boolean[] array = new boolean[this.model.getRowCount()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Boolean)this.model.getValueAt(i, 0);
        }
        return array;
    }

    private void initComponents() {
        this.dialogPanel1 = new DialogPanel();
        this.bClose = new JButton();
        this.jLabel1 = new JLabel();
        this.lblSelectedLines = new JLabel();
        this.lblMarkersFromChr = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.chromosomesTable = new JTable();
        this.selectAllLabel = new HyperLinkLabel();
        this.lblPipe = new JLabel();
        this.selectNoneLabel = new HyperLinkLabel();
        this.setDefaultCloseOperation(2);
        this.bClose.setText("Close");
        this.dialogPanel1.add((Component)this.bClose);
        this.jLabel1.setText("<html>Flapjack tasks only run on any selected lines and markers, however you can use the<br>settings here to exclude certain chromosomes if need be.");
        this.lblSelectedLines.setText("Number of lines currently selected in this view: {0} / {1}");
        this.lblMarkersFromChr.setText("Only use the selected markers from the following chromosomes:");
        this.chromosomesTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.chromosomesTable);
        this.selectAllLabel.setText("Select all");
        this.lblPipe.setText("|");
        this.selectNoneLabel.setText("Select none");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dialogPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblSelectedLines).addComponent(this.lblMarkersFromChr).addGroup(layout.createSequentialGroup().addComponent((Component)this.selectAllLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPipe).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.selectNoneLabel, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.lblSelectedLines).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMarkersFromChr, -2, 23, -2).addGap(1, 1, 1).addComponent(this.jScrollPane1, -1, 171, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.selectAllLabel, -2, -1, -2).addComponent((Component)this.selectNoneLabel, -2, -1, -2).addComponent(this.lblPipe)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dialogPanel1, -2, -1, -2)));
        this.pack();
    }

    private class ChromosomeSelectionTableModel
    extends AbstractTableModel {
        private final String[] columnNames;
        private final boolean[] selected;
        private int rowCount;
        private boolean rowCountModified = false;
        private final ArrayList<ChromosomeMap> maps;
        private final ArrayList<String> markerSelectionValues;

        ChromosomeSelectionTableModel(ArrayList<ChromosomeMap> maps, ArrayList<String> markerSelectionValues) {
            this.maps = maps;
            this.markerSelectionValues = markerSelectionValues;
            this.rowCount = maps.size();
            this.columnNames = new String[]{RB.getString((String)"gui.dialog.analysis.ChromosomeSelectionPanel.column1"), RB.getString((String)"gui.dialog.analysis.ChromosomeSelectionPanel.column2"), RB.getString((String)"gui.dialog.analysis.ChromosomeSelectionPanel.column3")};
            this.selected = new boolean[this.rowCount];
            for (int i = 0; i < this.selected.length; ++i) {
                if (markerSelectionValues.get(i).startsWith("0")) continue;
                this.selected[i] = true;
            }
            if (ChromosomeSelectionDialog.this.hideAllChrs && maps.get(this.rowCount - 1).isSpecialChromosome()) {
                this.rowCountModified = true;
                this.selected[this.rowCount - 1] = false;
                --this.rowCount;
            }
        }

        void updateForFinalSelection() {
            if (this.rowCountModified) {
                ++this.rowCount;
            }
        }

        @Override
        public int getRowCount() {
            return this.rowCount;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNames[columnIndex];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.selected[rowIndex];
                }
                case 1: {
                    return this.maps.get(rowIndex);
                }
                case 2: {
                    return this.markerSelectionValues.get(rowIndex);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                this.selected[rowIndex] = (Boolean)value;
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }
    }
}

