/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jhi.flapjack.data.Bookmark;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.Project;
import jhi.flapjack.data.results.Dendrogram;
import jhi.flapjack.data.results.SimMatrix;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.FileDropAdapter;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.TitlePanel;
import jhi.flapjack.gui.WinMain;
import jhi.flapjack.gui.navpanel.BaseNode;
import jhi.flapjack.gui.navpanel.BookmarkNode;
import jhi.flapjack.gui.navpanel.DataSetNode;
import jhi.flapjack.gui.navpanel.DendrogramNode;
import jhi.flapjack.gui.navpanel.IntroPanel;
import jhi.flapjack.gui.navpanel.MabcNode;
import jhi.flapjack.gui.navpanel.NavPanelMenu;
import jhi.flapjack.gui.navpanel.PedVerF1sNode;
import jhi.flapjack.gui.navpanel.PedVerLinesNode;
import jhi.flapjack.gui.navpanel.SimMatrixNode;
import jhi.flapjack.gui.navpanel.TraitsNode;
import jhi.flapjack.gui.navpanel.TreeRenderer;
import jhi.flapjack.gui.navpanel.VisualizationNode;
import jhi.flapjack.gui.simmatrix.SimMatrixPanel;
import jhi.flapjack.gui.traits.TabPanel;
import jhi.flapjack.gui.visualization.ChromosomePanel;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.OverviewManager;
import scri.commons.gui.RB;

public class NavPanel
extends JPanel
implements TreeSelectionListener,
PropertyChangeListener,
TreeExpansionListener {
    private JTree tree;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode root;
    private JSplitPane hSplitPane;
    private JSplitPane vSplitPane;
    private NavPanelMenu menu;
    private GenotypePanel gPanel;
    private ChromosomePanel cPanel;
    private DefaultMutableTreeNode defaultNode;
    private boolean isOpening = false;

    NavPanel(WinMain winMain) {
        this.resetModel();
        this.tree = new JTree(this.treeModel);
        this.tree.addTreeSelectionListener(this);
        this.tree.addTreeExpansionListener(this);
        this.tree.setCellRenderer(new TreeRenderer());
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.menu = new NavPanelMenu(this.tree);
        this.tree.addMouseListener(this.menu);
        JPanel treePanel = new JPanel(new BorderLayout());
        treePanel.add((Component)new TitlePanel(RB.getString((String)"gui.NavPanel.title")), "North");
        treePanel.add(new JScrollPane(this.tree));
        this.gPanel = new GenotypePanel(winMain);
        this.cPanel = new ChromosomePanel();
        this.vSplitPane = new JSplitPane(0);
        this.vSplitPane.setBorder(BorderFactory.createEmptyBorder());
        this.vSplitPane.setResizeWeight(1.0);
        this.vSplitPane.addPropertyChangeListener(this);
        this.vSplitPane.setDividerLocation(Prefs.guiOverviewSplitsLocation);
        this.vSplitPane.setTopComponent(treePanel);
        this.vSplitPane.setBottomComponent(OverviewManager.getPanel());
        this.hSplitPane = new JSplitPane(1);
        this.hSplitPane.setBorder(BorderFactory.createEmptyBorder());
        this.hSplitPane.addPropertyChangeListener(this);
        this.hSplitPane.setDividerLocation(Prefs.guiNavSplitsLocation);
        this.hSplitPane.setLeftComponent(this.vSplitPane);
        this.hSplitPane.setRightComponent(new IntroPanel());
        FileDropAdapter dropAdapter = new FileDropAdapter(winMain);
        this.setDropTarget(new DropTarget(this, dropAdapter));
        this.setLayout(new BorderLayout());
        this.add(this.hSplitPane);
    }

    GenotypePanel getGenotypePanel() {
        return this.gPanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.hSplitPane) {
            Prefs.guiNavSplitsLocation = this.hSplitPane.getDividerLocation();
        } else if (e.getSource() == this.vSplitPane) {
            Prefs.guiOverviewSplitsLocation = this.vSplitPane.getDividerLocation();
        }
    }

    private void resetModel() {
        this.root = new DefaultMutableTreeNode("root");
        this.treeModel = new DefaultTreeModel(this.root);
        this.defaultNode = null;
        this.updateTreeState();
    }

    void setProject(Project project) {
        String treeState = project.getTreeState();
        int[] selectedRows = project.getTreeSelectedRows();
        this.resetModel();
        this.tree.setModel(this.treeModel);
        this.isOpening = true;
        for (int i = 0; i < project.getDataSets().size(); ++i) {
            this.addDataSetNode(project.getDataSets().get(i));
        }
        this.setExpansionState(treeState);
        this.isOpening = false;
        if (selectedRows != null) {
            this.tree.setSelectionRows(selectedRows);
            this.tree.scrollRowToVisible(selectedRows[0]);
        } else if (this.defaultNode != null) {
            this.tree.setSelectionPath(new TreePath(this.defaultNode.getPath()));
            this.tree.scrollPathToVisible(new TreePath(this.defaultNode.getPath()));
        }
        Actions.projectSaved();
    }

    private void insert(DefaultMutableTreeNode node, DefaultMutableTreeNode parent, int index) {
        this.treeModel.insertNodeInto(node, parent, index);
        if (!this.isOpening) {
            this.tree.setSelectionPath(new TreePath(node.getPath()));
        }
        this.tree.scrollPathToVisible(new TreePath(node.getPath()));
    }

    void addDataSetNode(DataSet dataSet) {
        DataSetNode dataSetNode = new DataSetNode(dataSet);
        this.insert(dataSetNode, this.root, this.root.getChildCount());
        this.addTraitsNode(dataSetNode);
        for (GTViewSet viewSet : dataSet.getViewSets()) {
            this.addVisualizationNode(dataSet, viewSet);
        }
    }

    private void addTraitsNode(DataSetNode dataSetNode) {
        TraitsNode node = new TraitsNode(dataSetNode.getDataSet());
        this.insert(node, dataSetNode, 0);
    }

    public void addVisualizationNode(DataSet dataSet, GTViewSet viewSet) {
        DataSetNode dataSetNode = this.findDataSetNode(dataSet);
        VisualizationNode node = new VisualizationNode(dataSet, viewSet, this.gPanel, this.cPanel);
        this.insert(node, dataSetNode, dataSetNode.getChildCount());
        if (this.defaultNode == null) {
            this.defaultNode = node;
        }
        for (Bookmark bookmark : viewSet.getBookmarks()) {
            this.addBookmarkNode(viewSet, bookmark);
        }
        for (SimMatrix matrix : viewSet.getMatrices()) {
            this.addSimMatrixNode(viewSet, matrix);
        }
        for (Dendrogram dendrogram : viewSet.getDendrograms()) {
            this.addDendogramNode(viewSet, dendrogram);
        }
        this.addMabcNode(node, viewSet);
        this.addPedVerF1sNode(node, viewSet);
        this.addPedVerLinesNode(node, viewSet);
    }

    public void addBookmarkNode(GTViewSet viewSet, Bookmark bookmark) {
        VisualizationNode vNode = this.findVisualizationNode(viewSet);
        BookmarkNode node = new BookmarkNode(this.gPanel, vNode, bookmark);
        this.insert(node, vNode, vNode.getChildCount());
    }

    private void addMabcNode(VisualizationNode vNode, GTViewSet viewSet) {
        if (this.containsMabcResults(viewSet)) {
            MabcNode node = new MabcNode(this.gPanel, viewSet);
            this.insert(node, vNode, vNode.getChildCount());
        }
    }

    private boolean containsMabcResults(GTViewSet viewSet) {
        ArrayList<LineInfo> lines = viewSet.getLines();
        if (viewSet.getLines().isEmpty()) {
            lines = viewSet.getHideLines();
        }
        if (!lines.isEmpty()) {
            return lines.get(0).getResults().getMabcResult() != null;
        }
        return false;
    }

    public void addPedVerF1sNode(VisualizationNode vNode, GTViewSet viewSet) {
        if (this.containsPedVerF1sResults(viewSet)) {
            PedVerF1sNode node = new PedVerF1sNode(this.gPanel, viewSet);
            this.insert(node, vNode, vNode.getChildCount());
        }
    }

    private boolean containsPedVerF1sResults(GTViewSet viewSet) {
        ArrayList<LineInfo> lines = viewSet.getLines();
        if (viewSet.getLines().isEmpty()) {
            lines = viewSet.getHideLines();
        }
        if (!lines.isEmpty()) {
            return lines.get(0).getResults().getPedVerF1sResult() != null;
        }
        return false;
    }

    public void addPedVerLinesNode(VisualizationNode vNode, GTViewSet viewSet) {
        if (this.containsPedVerLinesResults(viewSet)) {
            PedVerLinesNode node = new PedVerLinesNode(this.gPanel, viewSet);
            this.insert(node, vNode, vNode.getChildCount());
        }
    }

    private boolean containsPedVerLinesResults(GTViewSet viewSet) {
        ArrayList<LineInfo> lines = viewSet.getLines();
        if (viewSet.getLines().isEmpty()) {
            lines = viewSet.getHideLines();
        }
        if (!lines.isEmpty()) {
            return lines.get(0).getResults().getPedVerLinesResult() != null;
        }
        return false;
    }

    public void addSimMatrixNode(GTViewSet viewSet, SimMatrix matrix) {
        VisualizationNode vNode = this.findVisualizationNode(viewSet);
        SimMatrixNode node = new SimMatrixNode(this.gPanel, viewSet, matrix);
        this.insert(node, vNode, vNode.getChildCount());
    }

    private void addDendogramNode(GTViewSet viewSet, Dendrogram dendrogram) {
        VisualizationNode vNode = this.findVisualizationNode(viewSet);
        DendrogramNode node = new DendrogramNode(this.gPanel, dendrogram);
        this.insert(node, vNode, vNode.getChildCount());
    }

    private DataSetNode findDataSetNode(DataSet dataSet) {
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            if (!(node instanceof DataSetNode) || ((DataSetNode)node).getDataSet() != dataSet) continue;
            return (DataSetNode)node;
        }
        return null;
    }

    private VisualizationNode findVisualizationNode(GTViewSet viewSet) {
        DataSetNode dataSetNode = this.findDataSetNode(viewSet.getDataSet());
        for (int i = 0; i < dataSetNode.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)dataSetNode.getChildAt(i);
            if (!(node instanceof VisualizationNode) || ((VisualizationNode)node).getViewSet() != viewSet) continue;
            return (VisualizationNode)node;
        }
        return null;
    }

    DataSet getDataSetForSelection() {
        BaseNode node = (BaseNode)this.tree.getLastSelectedPathComponent();
        return node == null ? null : node.getDataSet();
    }

    GTViewSet getViewSetForSelection() {
        BaseNode node = (BaseNode)this.tree.getLastSelectedPathComponent();
        if (node instanceof VisualizationNode) {
            return ((VisualizationNode)node).getViewSet();
        }
        return null;
    }

    BaseNode getNodeForSelection() {
        return (BaseNode)this.tree.getLastSelectedPathComponent();
    }

    void updateNodeFor(DataSet dataSet) {
        DataSetNode node = this.findDataSetNode(dataSet);
        this.treeModel.nodeChanged(node);
    }

    void updateNodeFor(GTViewSet viewSet) {
        VisualizationNode node = this.findVisualizationNode(viewSet);
        this.treeModel.nodeChanged(node);
    }

    void updateNode(BaseNode node) {
        this.treeModel.nodeChanged(node);
    }

    void removeDataSetNode(DataSet dataSet) {
        DataSetNode node = this.findDataSetNode(dataSet);
        this.treeModel.removeNodeFromParent(node);
    }

    void removeVisualizationNode(GTViewSet viewSet) {
        VisualizationNode node = this.findVisualizationNode(viewSet);
        this.treeModel.removeNodeFromParent(node);
    }

    Bookmark removeSelectedBookmarkNode() {
        BookmarkNode node = (BookmarkNode)this.tree.getLastSelectedPathComponent();
        BaseNode baseNode = (BaseNode)node.getParent();
        this.treeModel.removeNodeFromParent(node);
        this.tree.setSelectionPath(new TreePath(baseNode.getPath()));
        this.tree.scrollPathToVisible(new TreePath(baseNode.getPath()));
        return node.getBookmark();
    }

    public TabPanel getTraitsPanel(DataSet dataSet, boolean navigateTo) {
        DataSetNode dataSetNode = this.findDataSetNode(dataSet);
        TraitsNode traitsNode = (TraitsNode)dataSetNode.getChildAt(0);
        if (navigateTo) {
            this.tree.setSelectionPath(new TreePath(traitsNode.getPath()));
            this.tree.scrollPathToVisible(new TreePath(traitsNode.getPath()));
        }
        return (TabPanel)traitsNode.getPanel();
    }

    SimMatrixPanel getActiveSimMatrixPanel() {
        return (SimMatrixPanel)this.hSplitPane.getRightComponent();
    }

    public void toggleGenotypePanelViews() {
        this.valueChanged(null);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        BaseNode node = (BaseNode)this.tree.getLastSelectedPathComponent();
        Actions.resetActions();
        Flapjack.winMain.hideDialogs();
        int location = this.hSplitPane.getDividerLocation();
        if (node != null) {
            this.hSplitPane.setRightComponent(node.getPanel());
            node.setActions();
            Flapjack.winMain.getProject().setTreeSelectedRows(this.tree.getSelectionRows());
        } else {
            this.hSplitPane.setRightComponent(new IntroPanel());
        }
        this.hSplitPane.setDividerLocation(location);
        OverviewManager.setVisible(node instanceof VisualizationNode || node instanceof BookmarkNode);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.updateTreeState();
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.updateTreeState();
    }

    private void updateTreeState() {
        if (this.tree != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                if (!this.tree.isExpanded(i)) continue;
                sb.append(i).append(",");
            }
            Flapjack.winMain.getProject().setTreeState(sb.toString());
            Flapjack.winMain.getProject().setTreeSelectedRows(this.tree.getSelectionRows());
        }
    }

    public void setExpansionState(String s) {
        if (s.isEmpty()) {
            return;
        }
        String[] indexes = s.split(",");
        this.tree.removeTreeExpansionListener(this);
        for (int i = this.tree.getRowCount() - 1; i >= 0; --i) {
            this.tree.collapseRow(i);
        }
        for (String st : indexes) {
            if (st.isEmpty()) continue;
            int row = Integer.parseInt(st);
            this.tree.expandRow(row);
        }
        this.updateTreeState();
        this.tree.addTreeExpansionListener(this);
    }
}

