/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.data;

import java.awt.Color;
import jhi.flapjack.data.Trait;
import jhi.flapjack.data.XMLRoot;

public class TraitValue
extends XMLRoot {
    private Trait trait;
    private float value;
    private float normal;
    private boolean isDefined;

    public TraitValue() {
    }

    public TraitValue(Trait trait) {
        this.trait = trait;
        this.isDefined = false;
    }

    public TraitValue(Trait trait, float value) {
        this.trait = trait;
        this.value = value;
        this.isDefined = true;
    }

    void validate() throws NullPointerException {
        if (this.trait == null) {
            throw new NullPointerException();
        }
        if (Float.isNaN(this.normal)) {
            this.normal = 0.0f;
        }
    }

    public Trait getTrait() {
        return this.trait;
    }

    public void setTrait(Trait trait) {
        this.trait = trait;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public float getNormal() {
        return this.normal;
    }

    public void setNormal(float normal) {
        this.normal = normal;
    }

    public boolean isDefined() {
        return this.isDefined;
    }

    public void setDefined(boolean isDefined) {
        this.isDefined = isDefined;
    }

    public int compareTo(TraitValue other) {
        if (!this.isDefined && !other.isDefined) {
            return 0;
        }
        if (!this.isDefined) {
            return -1;
        }
        if (!other.isDefined) {
            return 1;
        }
        if (this.trait.traitIsNumerical()) {
            if (this.value < other.value) {
                return -1;
            }
            if (this.value == other.value) {
                return 0;
            }
            return 1;
        }
        String myCat = this.trait.format(this);
        String otherCat = this.trait.format(other);
        return myCat.compareTo(otherCat);
    }

    public void computeNormal() {
        float min = this.trait.min;
        float max = this.trait.max;
        this.normal = (this.value - min) / (max - min);
        if (Float.isNaN(this.normal)) {
            this.normal = 0.0f;
        }
    }

    public String formatForCurlyWhirly() {
        if (!this.isDefined) {
            return "\t";
        }
        if (this.trait.traitIsNumerical()) {
            return this.getValue() + "\t";
        }
        return this.trait.format(this) + "\t";
    }

    public Color displayColor() {
        return this.trait.displayColor(this.value, this.normal);
    }

    public Object tableValue() {
        if (!this.isDefined()) {
            return null;
        }
        if (this.trait.traitIsNumerical()) {
            return (double)this.getValue();
        }
        return this.trait.format(this);
    }
}

