/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.resource;

import org.restlet.data.MediaType;
import org.restlet.engine.resource.MethodAnnotationInfo;
import org.restlet.representation.Variant;

public class VariantInfo
extends Variant {
    private final MethodAnnotationInfo annotationInfo;
    private float inputScore;

    public VariantInfo(MediaType mediaType) {
        this(mediaType, (MethodAnnotationInfo)null);
    }

    public VariantInfo(MediaType mediaType, MethodAnnotationInfo annotationInfo) {
        super(mediaType);
        this.annotationInfo = annotationInfo;
        this.inputScore = 1.0f;
    }

    public VariantInfo(Variant variant, MethodAnnotationInfo annotationInfo) {
        this(variant.getMediaType(), annotationInfo);
        this.setCharacterSet(variant.getCharacterSet());
        this.setEncodings(variant.getEncodings());
        this.setLanguages(variant.getLanguages());
    }

    @Override
    public boolean equals(Object other) {
        boolean result;
        boolean bl = result = super.equals(other) && other instanceof VariantInfo;
        if (result && other != this) {
            VariantInfo otherVariant = (VariantInfo)other;
            if (result) {
                result = this.getAnnotationInfo() == null && otherVariant.getAnnotationInfo() == null || this.getAnnotationInfo() != null && this.getAnnotationInfo().equals(otherVariant.getAnnotationInfo());
            }
        }
        return result;
    }

    public MethodAnnotationInfo getAnnotationInfo() {
        return this.annotationInfo;
    }

    public float getInputScore() {
        return this.inputScore;
    }

    public void setInputScore(float inputScore) {
        this.inputScore = inputScore;
    }
}

