/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.io.IOException;
import org.restlet.data.CharacterSet;
import org.restlet.data.Reference;
import org.restlet.engine.util.SystemUtils;
import org.restlet.util.NamedValue;

public class Parameter
implements Comparable<Parameter>,
NamedValue<String> {
    private volatile String name;
    private volatile String value;

    public static Parameter create(CharSequence name, CharSequence value) {
        if (value != null) {
            return new Parameter(name.toString(), value.toString());
        }
        return new Parameter(name.toString(), null);
    }

    public Parameter() {
        this(null, null);
    }

    public Parameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public int compareTo(Parameter o) {
        return this.getName().compareTo(o.getName());
    }

    public void encode(Appendable buffer, CharacterSet characterSet) throws IOException {
        if (this.getName() != null) {
            buffer.append(Reference.encode(this.getName(), characterSet));
            if (this.getValue() != null) {
                buffer.append('=');
                buffer.append(Reference.encode(this.getValue(), characterSet));
            }
        }
    }

    public String encode(CharacterSet characterSet) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.encode(sb, characterSet);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && (result = obj instanceof Parameter)) {
            Parameter that = (Parameter)obj;
            boolean bl2 = result = that.getName() == null && this.getName() == null || this.getName() != null && this.getName().equals(that.getName());
            if (result) {
                result = that.getValue() == null && this.getValue() == null || this.getValue() != null && this.getValue().equals(that.getValue());
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return SystemUtils.hashCode(this.getName(), this.getValue());
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "[" + this.getName() + "=" + this.getValue() + "]";
    }
}

