/*
 * Decompiled with CFR 0.152.
 */
package scri.commons.gui.matisse;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JLabel;

public class HyperLinkLabel
extends JLabel {
    private String labelText;
    private ArrayList<ActionListener> actionListeners = new ArrayList();

    public HyperLinkLabel() {
        this.setForeground(Color.blue);
        this.setCursor(new Cursor(12));
        final HyperLinkLabel labelRef = this;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!labelRef.isEnabled()) {
                    return;
                }
                for (ActionListener l : HyperLinkLabel.this.actionListeners) {
                    l.actionPerformed(new ActionEvent(labelRef, 1001, "HyperLinkLabel Clicked"));
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (labelRef.isEnabled()) {
                    labelRef.setText("<u>" + HyperLinkLabel.this.getCleanText() + "</u>");
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                labelRef.setText(HyperLinkLabel.this.getCleanText());
            }
        });
    }

    private String getCleanText() {
        String text = this.getText();
        text = text.replaceAll("<html>", "");
        text = text.replaceAll("</html>", "");
        text = text.replaceAll("<u>", "");
        text = text.replaceAll("</u>", "");
        return text;
    }

    @Override
    public void setText(String text) {
        super.setText("<html>" + text + "</html>");
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }
}

