/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.brapi;

import java.util.List;
import jhi.brapi.api.calls.BrapiCall;

class CallsUtils {
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String JSON = "json";
    private static final String TSV = "tsv";
    private static final String FLAPJACK = "flapjack";
    private List<BrapiCall> calls;

    CallsUtils(List<BrapiCall> calls) {
        this.calls = calls;
    }

    boolean validate() {
        if (!this.hasCall("studies-search", JSON, GET)) {
            return false;
        }
        if (!this.hasCall("maps", JSON, GET)) {
            return false;
        }
        if (!this.hasCall("maps/id/positions", JSON, GET)) {
            return false;
        }
        if (!this.hasCall("markerprofiles", JSON, GET)) {
            return false;
        }
        return this.hasCall("allelematrix-search", JSON, POST) || this.hasAlleleMatrixSearchTSV() || this.hasAlleleMatrixSearchFlapjack();
    }

    boolean hasCall(String signature, String datatype, String method) {
        for (BrapiCall call : this.calls) {
            if (!call.getCall().equals(signature) || !call.getDatatypes().contains(datatype) || !call.getMethods().contains(method)) continue;
            return true;
        }
        return false;
    }

    boolean hasToken() {
        return this.hasCall("token", JSON, GET);
    }

    boolean hasMapsMapDbId() {
        return this.hasCall("maps/id", JSON, GET);
    }

    boolean hasAlleleMatrixSearchTSV() {
        return this.hasCall("allelematrix-search", TSV, POST);
    }

    boolean hasAlleleMatrixSearchFlapjack() {
        return this.hasCall("allelematrix-search", FLAPJACK, POST);
    }
}

