/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import jhi.flapjack.data.ISerializableDB;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.io.DatabaseInputStream;
import jhi.flapjack.io.DatabaseOutputStream;
import jhi.flapjack.io.FlapjackFile;

public class ProjectSerializerDB {
    private static Connection c;
    private static HashMap<ISerializableDB, File> cache;

    static void initConnection(FlapjackFile file, boolean isSaveOperation) throws IOException, SQLException {
        if (c != null) {
            c.close();
        }
        c = DriverManager.getConnection("jdbc:sqlite:" + file.getPath());
        if (isSaveOperation && !ProjectSerializerDB.isDatabase(file)) {
            System.out.println("No SQLite format 3 header");
            new BufferedWriter(new FileWriter(file.getPath()));
        }
    }

    static boolean isDatabase(FlapjackFile file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(file.getInputStream());
        byte[] header = new byte[16];
        in.read(header, 0, 16);
        in.close();
        return new String(header).startsWith("SQLite format 3");
    }

    static void initDatabase() throws SQLException {
        Statement st = c.createStatement();
        st.execute("PRAGMA locking_mode = EXCLUSIVE;");
        st.execute("PRAGMA journal_mode = OFF;");
        st.execute("PRAGMA synchronous = OFF;");
        st.execute("PRAGMA count_changes = false;");
        st.executeUpdate("CREATE TABLE IF NOT EXISTS project (data BLOB);");
        st.executeUpdate("CREATE TABLE IF NOT EXISTS objects (id STRING, type STRING, data BLOB);");
        st.close();
        PreparedStatement ps = c.prepareStatement("DELETE FROM project;");
        ps.executeUpdate();
        ps.close();
    }

    static OutputStream getProjectOutputStream() throws SQLException {
        PreparedStatement ps = c.prepareStatement("INSERT INTO project (data) VALUES (?);");
        return new DatabaseOutputStream(ps, 1);
    }

    static InputStream getProjectInputStream() throws SQLException {
        PreparedStatement ps = c.prepareStatement("SELECT * FROM project;");
        return new DatabaseInputStream(ps, 1);
    }

    public static void close() throws SQLException {
        if (c != null) {
            c.close();
        }
    }

    public static void vacuum() throws SQLException {
        if (c != null) {
            PreparedStatement ps = c.prepareStatement("VACUUM;");
            ps.execute();
            ps.close();
        }
    }

    public static void cacheToDisk(ISerializableDB obj) throws Exception {
        File file = new File(FlapjackUtils.getCacheDir(), obj.getDatabaseID() + ".obj");
        file.deleteOnExit();
        cache.put(obj, file);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        out.writeObject(obj.dbGetObject());
        out.close();
        System.out.println("Cached " + obj.getDatabaseID() + ": " + obj);
    }

    public static void cacheToDatabase() throws Exception {
        for (ISerializableDB obj : cache.keySet()) {
            PreparedStatement ps = c.prepareStatement("INSERT INTO objects (id, type, data) VALUES (?, ?, ?);");
            ps.setString(1, obj.getDatabaseID());
            ps.setString(2, obj.dbGetType());
            DatabaseOutputStream out = new DatabaseOutputStream(ps, 3);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(cache.get(obj)));
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            in.close();
            ((OutputStream)out).close();
        }
        cache.clear();
    }

    public static void setFromCache(ISerializableDB obj) {
        try {
            ObjectInputStream in = null;
            if (cache.containsKey(obj)) {
                System.out.println("Load from disk...");
                File file = new File(FlapjackUtils.getCacheDir(), obj.getDatabaseID() + ".obj");
                in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            } else {
                System.out.println("Load from DB...");
                PreparedStatement ps = c.prepareStatement("SELECT data FROM objects WHERE id=?;");
                ps.setString(1, obj.getDatabaseID());
                in = new ObjectInputStream(new BufferedInputStream(new DatabaseInputStream(ps, 1)));
            }
            obj.dbSetObject(in.readObject());
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        cache = new HashMap();
    }
}

