/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;
import jhi.flapjack.analysis.SortLinesByTrait;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.Trait;
import jhi.flapjack.data.TraitValue;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import jhi.flapjack.gui.visualization.GenotypePanel;
import scri.commons.gui.ITrackableJob;
import scri.commons.gui.RB;

class TraitCanvasML
extends MouseInputAdapter
implements ActionListener {
    private NumberFormat nf = NumberFormat.getInstance();
    private GenotypePanel gPanel;
    private GenotypeCanvas canvas;
    private int mouseOverIndex;
    private int boxW;
    private int menuTraitIndex;
    private JMenuItem sortAsc;
    private JMenuItem sortDec;
    private JMenuItem sortAdv;
    private JMenuItem selectTraits;
    private JCheckBoxMenuItem showCatBoundaries;

    TraitCanvasML(GenotypePanel gPanel, GenotypeCanvas canvas, int boxW) {
        this.gPanel = gPanel;
        this.canvas = canvas;
        this.boxW = boxW;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.gPanel.statusPanel.setForHeatmapUse();
        this.mouseOverIndex = e.getPoint().x / this.boxW;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.gPanel.statusPanel.setForMainUse();
        this.gPanel.statusPanel.setHeatmapValues(" ", " ", " ");
        this.mouseOverIndex = -1;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int y = e.getPoint().y + this.canvas.pY1;
        int yIndex = y / this.canvas.boxH;
        this.mouseOverIndex = e.getPoint().x / this.boxW;
        int[] traits = this.canvas.viewSet.getTraits();
        if (this.mouseOverIndex < 0 || this.mouseOverIndex >= traits.length) {
            return;
        }
        int tIndex = traits[this.mouseOverIndex];
        if (tIndex == -1 || yIndex > this.canvas.view.lineCount() - 1) {
            this.gPanel.statusPanel.setHeatmapValues(" ", " ", " ");
            return;
        }
        Line line = this.canvas.view.getLine(yIndex);
        if (this.canvas.view.isDummyLine(yIndex) || this.canvas.view.isSplitter(yIndex)) {
            this.gPanel.statusPanel.setHeatmapValues(" ", " ", " ");
            return;
        }
        TraitValue tv = line.getTraitValues().get(tIndex);
        String trait = tv.getTrait().getName();
        if (tv.getTrait().experimentDefined()) {
            trait = trait + " (" + tv.getTrait().getExperiment() + ")";
        }
        String value = " ";
        if (tv.isDefined() && tv.getTrait().traitIsNumerical()) {
            value = this.nf.format(tv.getValue());
        } else if (tv.isDefined()) {
            value = tv.getTrait().format(tv);
        }
        String name = this.canvas.view.getLineInfo(yIndex).name();
        this.gPanel.statusPanel.setHeatmapValues(name, trait, value);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.handlePopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.handlePopup(e);
        }
    }

    private void handlePopup(MouseEvent e) {
        int[] traits = this.canvas.viewSet.getTraits();
        this.menuTraitIndex = traits[this.mouseOverIndex];
        JPopupMenu menu = new JPopupMenu();
        this.sortAsc = new JMenuItem();
        this.sortAsc.addActionListener(this);
        this.sortDec = new JMenuItem();
        this.sortDec.addActionListener(this);
        if (this.getSelectedTrait().traitIsNumerical()) {
            RB.setText((AbstractButton)this.sortAsc, (String)"gui.visualization.TraitCanvasML.sortAscNum");
            RB.setText((AbstractButton)this.sortDec, (String)"gui.visualization.TraitCanvasML.sortDecNum");
        } else {
            RB.setText((AbstractButton)this.sortAsc, (String)"gui.visualization.TraitCanvasML.sortAscCat");
            RB.setText((AbstractButton)this.sortDec, (String)"gui.visualization.TraitCanvasML.sortDecCat");
        }
        this.sortAdv = new JMenuItem();
        RB.setText((AbstractButton)this.sortAdv, (String)"gui.visualization.TraitCanvasML.sortAdv");
        this.sortAdv.addActionListener(this);
        this.selectTraits = new JMenuItem();
        RB.setText((AbstractButton)this.selectTraits, (String)"gui.visualization.TraitCanvasML.selectTraits");
        this.selectTraits.addActionListener(this);
        this.showCatBoundaries = new JCheckBoxMenuItem();
        RB.setText((AbstractButton)this.showCatBoundaries, (String)"gui.visualization.TraitCanvasML.showCatBoundaries");
        this.showCatBoundaries.setSelected(Prefs.visShowCatBoundaries);
        this.showCatBoundaries.addActionListener(this);
        menu.add(this.sortAsc);
        menu.add(this.sortDec);
        menu.add(this.sortAdv);
        menu.addSeparator();
        menu.add(this.selectTraits);
        menu.addSeparator();
        menu.add(this.showCatBoundaries);
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.selectTraits) {
            Flapjack.winMain.mData.dataSelectTraits();
        } else if (e.getSource() == this.sortAsc) {
            this.runSort(true);
        } else if (e.getSource() == this.sortDec) {
            this.runSort(false);
        } else if (e.getSource() == this.sortAdv) {
            Flapjack.winMain.mAnalysis.sortLinesByTrait();
        } else if (e.getSource() == this.showCatBoundaries) {
            this.toggleCatBoundaries();
        }
    }

    private void runSort(boolean ascending) {
        int[] traits = new int[]{this.menuTraitIndex};
        SortLinesByTrait sort = new SortLinesByTrait(this.gPanel.getViewSet(), this.menuTraitIndex, ascending);
        Flapjack.winMain.mAnalysis.runSort((ITrackableJob)sort, this.gPanel.getViewSet());
    }

    private Trait getSelectedTrait() {
        DataSet dataSet = this.gPanel.getViewSet().getDataSet();
        return dataSet.getTraits().get(this.menuTraitIndex);
    }

    private void toggleCatBoundaries() {
        Prefs.visShowCatBoundaries = !Prefs.visShowCatBoundaries;
        Flapjack.winMain.repaint();
    }
}

