/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jhi.flapjack.gui.visualization.ChromosomeCanvas;
import scri.commons.gui.RB;

public class ChromosomeCanvasKey
extends JPanel {
    private boolean redraw;
    private BufferedImage imageViewPort;
    private Dimension dimension = new Dimension();
    private ChromosomeCanvas chromCanvas;
    private Canvas2D canvas2D;

    ChromosomeCanvasKey(ChromosomeCanvas chromCanvas) {
        this.chromCanvas = chromCanvas;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ChromosomeCanvasKey.this.redraw();
            }
        });
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)new JLabel(RB.getString((String)"gui.visualization.ChromosomeCanvasKey.label")), "North");
        this.canvas2D = new Canvas2D();
        this.add(this.canvas2D);
        this.add((Component)new JLabel(), "South");
    }

    public void redraw() {
        this.redraw = true;
        this.canvas2D.repaint();
    }

    private class Canvas2D
    extends JPanel {
        Canvas2D() {
            this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D g = (Graphics2D)graphics;
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (ChromosomeCanvasKey.this.redraw) {
                int w = this.getWidth();
                int h = this.getHeight();
                if (ChromosomeCanvasKey.this.imageViewPort == null || ChromosomeCanvasKey.this.imageViewPort.getWidth() != w || ChromosomeCanvasKey.this.imageViewPort.getHeight() != h) {
                    ChromosomeCanvasKey.this.imageViewPort = (BufferedImage)this.createImage(w, h);
                }
                Graphics2D gImage = ChromosomeCanvasKey.this.imageViewPort.createGraphics();
                this.renderCanvas(gImage, w, h);
                gImage.dispose();
            }
            g.drawImage((Image)ChromosomeCanvasKey.this.imageViewPort, 0, 0, null);
            ChromosomeCanvasKey.this.redraw = false;
        }

        private void renderCanvas(Graphics2D g, int w, int h) {
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, w, h);
            for (int i = 0; i < w; ++i) {
                int alpha = 0 + (int)(255.0f * (255.0f * ((float)i / (float)w)) / 255.0f);
                g.setColor(new Color(70, 116, 162, alpha));
                g.drawLine(i, 0, i, h);
            }
            g.setColor(Color.BLACK);
            String low = RB.format((String)"gui.visualization.ChromosomeCanvasKey.low", (Object[])new Object[]{ChromosomeCanvasKey.this.chromCanvas.minMarkerCount()});
            g.drawString(low, 5, 12);
            g.setColor(Color.WHITE);
            String high = RB.format((String)"gui.visualization.ChromosomeCanvasKey.high", (Object[])new Object[]{ChromosomeCanvasKey.this.chromCanvas.maxMarkerCount()});
            g.drawString(high, w - 5 - g.getFontMetrics().stringWidth(high), 12);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(0, 16);
        }
    }
}

