/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jhi.flapjack.data.GTView;
import jhi.flapjack.gui.visualization.ChromosomeCanvas;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import scri.commons.gui.RB;

public class ChromosomeCanvasGraph
extends JPanel {
    private ChromosomeCanvas chromCanvas;
    private JFreeChart chart;

    ChromosomeCanvasGraph(ChromosomeCanvas chromCanvas) {
        this.chromCanvas = chromCanvas;
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.chart = this.createChart();
        ChartPanel panel = new ChartPanel(this.chart);
        panel.setMaximumDrawWidth(2000);
        panel.setMaximumDrawHeight(500);
        this.add((Component)panel);
        this.display(-1);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(0, 150);
    }

    void display(int chromosomeIndex) {
        if (chromosomeIndex == -1) {
            this.setChartData(null);
            this.setBorder(BorderFactory.createTitledBorder(RB.getString((String)"flapjack.gui.visualization.ChromosomePanel.graphTitle1")));
        } else {
            GTView view = this.chromCanvas.views.get(chromosomeIndex);
            int nBins = 500;
            double cmPerPixel = view.mapLength() / (double)nBins;
            float[] values = this.chromCanvas.calculateMarkersPerPixel(view, cmPerPixel, nBins);
            double[][] data = new double[values.length][2];
            for (int i = 0; i < values.length; ++i) {
                data[i][0] = (double)i * cmPerPixel;
                data[i][1] = values[i];
            }
            this.chart.getXYPlot().getRangeAxis().setAutoRange(true);
            this.chart.getXYPlot().getDomainAxis().setAutoRange(true);
            this.setChartData(data);
            this.setBorder(BorderFactory.createTitledBorder(RB.format((String)"flapjack.gui.visualization.ChromosomePanel.graphTitle2", (Object[])new Object[]{this.chromCanvas.views.get(chromosomeIndex).getChromosomeMap().getName()})));
        }
        this.repaint();
    }

    public void setChartData(double[][] data) {
        XYSeries series = new XYSeries((Comparable)((Object)""));
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                series.add(data[i][0], data[i][1]);
            }
        }
        XYSeriesCollection coll = new XYSeriesCollection(series);
        this.chart.getXYPlot().setDataset((XYDataset)coll);
        this.displayAxis(data != null);
    }

    private void displayAxis(boolean visible) {
        XYPlot plot = (XYPlot)this.chart.getPlot();
        ValueAxis range = plot.getRangeAxis();
        range.setVisible(visible);
        range = plot.getDomainAxis();
        range.setVisible(visible);
    }

    private JFreeChart createChart() {
        JFreeChart chart = ChartFactory.createXYAreaChart(null, null, null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        chart.setRenderingHints(rh);
        chart.removeLegend();
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinePaint((Paint)Color.GRAY);
        plot.setRangeGridlinePaint((Paint)Color.GRAY);
        NumberAxis xAxis = (NumberAxis)plot.getDomainAxis();
        NumberAxis yAxis = (NumberAxis)plot.getRangeAxis();
        yAxis.setTickLabelFont(new JLabel().getFont());
        return chart;
    }
}

