/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.table;

import java.util.ArrayList;
import javax.swing.RowSorter;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.XMLRoot;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.table.FilterColumn;
import jhi.flapjack.gui.table.ITableViewListener;
import jhi.flapjack.gui.table.LineDataTable;
import jhi.flapjack.gui.table.LineDataTableModel;
import jhi.flapjack.gui.table.SortColumn;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.undo.MovedLinesState;

public class LinkedTableHandler
extends XMLRoot
implements ITableViewListener {
    private GTViewSet viewSet;
    private LineDataTable table;
    private LineDataTableModel model;
    private ArrayList<SortColumn> sortKeys;
    private SortColumn[] lastSort;
    private FilterColumn[] dialogFilter;
    private FilterColumn[] tableFilter;
    private FilterColumn[] lastSelect;
    private boolean autoResize = true;
    private MovedLinesState undoSort;
    private boolean isChanging = false;

    public LinkedTableHandler() {
    }

    public LinkedTableHandler(GTViewSet viewSet) {
        this.viewSet = viewSet;
    }

    public GTViewSet getViewSet() {
        return this.viewSet;
    }

    public void setViewSet(GTViewSet viewSet) {
        this.viewSet = viewSet;
    }

    public ArrayList<SortColumn> getSortKeys() {
        return this.sortKeys;
    }

    public void setSortKeys(ArrayList<SortColumn> sortKeys) {
        this.sortKeys = sortKeys;
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public void setAutoResize(boolean autoResize) {
        this.autoResize = autoResize;
    }

    public FilterColumn[] getDialogFilter() {
        return this.dialogFilter;
    }

    public void setDialogFilter(FilterColumn[] dialogFilter) {
        this.dialogFilter = dialogFilter;
    }

    public FilterColumn[] getTableFilter() {
        return this.tableFilter;
    }

    public void setTableFilter(FilterColumn[] tableFilter) {
        this.tableFilter = tableFilter;
    }

    public SortColumn[] getLastSort() {
        return this.lastSort;
    }

    public void setLastSort(SortColumn[] lastSort) {
        this.lastSort = lastSort;
    }

    public FilterColumn[] getLastSelect() {
        return this.lastSelect;
    }

    public void setLastSelect(FilterColumn[] lastSelect) {
        this.lastSelect = lastSelect;
    }

    public void linkTable(LineDataTable table, LineDataTableModel model) {
        this.table = table;
        this.model = model;
        table.addViewListener(this);
        this.doPostLoadOperations();
    }

    public void copyTableToView() {
        if (this.table == null) {
            return;
        }
        this.viewSet.getLines().clear();
        this.viewSet.getHideLines().clear();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            int col0 = this.table.convertColumnIndexToView(0);
            ((LineInfo)this.table.getObjectAt(i, col0)).setVisibility(LineInfo.VISIBLE);
            this.viewSet.getLines().add((LineInfo)this.table.getObjectAt(i, col0));
        }
        ArrayList<LineInfo> hideLines = new ArrayList<LineInfo>(this.model.getLines());
        hideLines.removeAll(this.viewSet.getLines());
        this.viewSet.getHideLines().addAll(hideLines);
        for (LineInfo lineInfo : hideLines) {
            if (lineInfo.getVisibility() != LineInfo.VISIBLE) continue;
            lineInfo.setVisibility(LineInfo.FILTERED);
        }
    }

    @Override
    public void tableSorted() {
        this.updateTrackers();
        if (this.isChanging) {
            return;
        }
        this.isChanging = true;
        this.copyTableToView();
        Actions.projectModified();
        if (this.undoSort != null) {
            this.undoSort.createRedoState();
            GenotypePanel gPanel = Flapjack.winMain.getGenotypePanel();
            gPanel.addUndoState(this.undoSort);
        }
        this.isChanging = false;
    }

    @Override
    public void tableFiltered() {
        this.updateTrackers();
        if (this.isChanging) {
            return;
        }
        this.isChanging = true;
        this.copyTableToView();
        this.isChanging = false;
    }

    private void updateTrackers() {
        this.sortKeys = this.table.getRowSorter().getSortKeys().isEmpty() ? null : new ArrayList();
        for (RowSorter.SortKey key : this.table.getRowSorter().getSortKeys()) {
            this.sortKeys.add(new SortColumn(key.getColumn(), key.getSortOrder()));
        }
        this.lastSort = this.table.getLastSort();
        this.lastSelect = this.table.getLastSelect();
        this.dialogFilter = this.table.getDialogFilter();
        this.tableFilter = this.table.getTableFilter();
    }

    public ArrayList<LineInfo> linesForTable() {
        ArrayList<LineInfo> lines = new ArrayList<LineInfo>(this.viewSet.getLines());
        lines.addAll(this.viewSet.getHideLines());
        return lines;
    }

    public void copyViewToTable(boolean setModel) {
        if (this.table == null) {
            return;
        }
        if (this.isChanging) {
            return;
        }
        this.isChanging = true;
        this.model.setLines(this.linesForTable());
        if (setModel) {
            this.table.setModel(this.model);
            this.table.filter();
        } else {
            this.model.fireTableDataChanged();
        }
        this.isChanging = false;
    }

    public LineDataTable table() {
        return this.table;
    }

    public LineDataTableModel model() {
        return this.model;
    }

    private void doPostLoadOperations() {
        this.table.autoResize(this.autoResize, true);
        this.table.setDialogFilter(this.dialogFilter);
        this.table.setTableFilter(this.tableFilter);
        this.table.setLastSort(this.lastSort);
        this.table.setLastSelect(this.lastSelect);
        if (this.sortKeys != null) {
            ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
            for (SortColumn entry : this.sortKeys) {
                keys.add(new RowSorter.SortKey(entry.colIndex, entry.sortOrder));
            }
            this.table.sorter().setSortKeys(keys);
            this.table.sorter().sort();
        }
        this.table.filter();
    }

    @Override
    public void tablePreSorted() {
        this.undoSort = new MovedLinesState(this.viewSet, "table sorted");
        this.undoSort.createUndoState();
    }

    public void undoRedoApplySort(ArrayList<SortColumn> sortKeys) {
        if (this.table == null) {
            return;
        }
        this.isChanging = true;
        this.undoSort = null;
        ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
        if (sortKeys != null) {
            for (SortColumn entry : sortKeys) {
                keys.add(new RowSorter.SortKey(entry.colIndex, entry.sortOrder));
            }
        }
        this.table.sorter().setSortKeys(keys);
        this.table.sorter().sort();
        this.isChanging = false;
    }

    public void undoRedoApplyFilter(FilterColumn[] filters) {
        if (this.table == null) {
            return;
        }
        this.isChanging = true;
        this.table.setTableFilter(filters);
        this.table.filter();
        this.isChanging = false;
    }
}

