/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.colors;

import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.StateTable;
import jhi.flapjack.gui.visualization.colors.ColorState;
import jhi.flapjack.gui.visualization.colors.LineSimilarityColorScheme;
import scri.commons.gui.RB;

public class LineSimilarityAnyColorScheme
extends LineSimilarityColorScheme {
    private StateTable stateTable;

    public LineSimilarityAnyColorScheme() {
    }

    public LineSimilarityAnyColorScheme(GTView view, int w, int h) {
        super(view, w, h);
        this.stateTable = view.getViewSet().getDataSet().getStateTable();
    }

    @Override
    protected ColorState getState(int line, int marker) {
        int state = this.view.getState(line, marker);
        AlleleState alleleState = this.stateTable.getAlleleState(state);
        int comparisonIndex = this.view.getViewSet().getComparisonLineIndex();
        if (line == comparisonIndex) {
            return (ColorState)this.compStates.get(state);
        }
        if (comparisonIndex != -1) {
            int compState = this.view.getState(comparisonIndex, marker);
            AlleleState compAlleleState = this.stateTable.getAlleleState(compState);
            if (compState == 0) {
                return (ColorState)this.gsStates.get(state);
            }
            if (alleleState.matchesAnyAllele(compAlleleState)) {
                return (ColorState)this.mtchStatesY.get(state);
            }
            return (ColorState)this.mtchStatesN.get(state);
        }
        return (ColorState)this.gsStates.get(state);
    }

    @Override
    public int getModel() {
        return 14;
    }

    @Override
    public String toString() {
        return RB.getString((String)"gui.Actions.vizColorLineSimAny");
    }

    @Override
    public String getDescription() {
        return RB.getString((String)"gui.visualization.colors.LineSimilarityAnyMatchColorScheme");
    }
}

