/*
 * Decompiled with CFR 0.152.
 */
package org.ggf.drmaa;

import java.io.Serializable;

public class Version
implements Serializable,
Cloneable,
Comparable {
    private int major;
    private int minor;

    public Version(int major, int minor) {
        if (major < 0) {
            throw new IllegalArgumentException("Major version number must be non-negative");
        }
        if (minor < 0) {
            throw new IllegalArgumentException("Minor version number must be non-negative");
        }
        this.major = major;
        this.minor = minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String toString() {
        return Integer.toString(this.major) + "." + Integer.toString(this.minor);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Version)) {
            return false;
        }
        return ((Version)obj).major == this.major && ((Version)obj).minor == this.minor;
    }

    public int hashCode() {
        return this.major * 100 + this.minor;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int compareTo(Object o) {
        Version version = (Version)o;
        int ret = this.major - version.major;
        if (ret == 0) {
            ret = this.minor - version.minor;
        }
        return ret;
    }
}

