/*
 * Decompiled with CFR 0.152.
 */
package org.ggf.drmaa;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class PartialTimestamp
extends Calendar {
    public static final int CENTURY = 0;
    public static final int UNSET = Integer.MAX_VALUE;
    private static final long ONE_SECOND = 1000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    private static final long ONE_YEAR = 31536000000L;
    private static final long THREE_YEARS = 94608000000L;
    private static final long FOUR_YEARS = 126230400000L;
    private static final long ONE_HUNDRED_YEARS = 3155673600000L;
    private static final long FOUR_HUNDRED_YEARS = 12622780800000L;
    private static final int[] DRMAA_FIELDS = new int[]{0, 1, 2, 5, 11, 12, 13};
    private int[] modifiers = null;
    private int lastHourSet = 11;
    private int dayStamp = 0;
    private int monthSet = Integer.MAX_VALUE;
    private int dayOfWeekSet = Integer.MAX_VALUE;
    private int dayOfMonthSet = Integer.MAX_VALUE;
    private int dayOfWeekInMonthSet = Integer.MAX_VALUE;
    private int dayOfYearSet = Integer.MAX_VALUE;
    private int weekOfMonthSet = Integer.MAX_VALUE;
    private int weekOfYearSet = Integer.MAX_VALUE;
    private boolean fieldsModified = true;

    public PartialTimestamp() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public PartialTimestamp(TimeZone zone) {
        this(zone, Locale.getDefault());
    }

    public PartialTimestamp(Locale aLocale) {
        this(TimeZone.getDefault(), aLocale);
    }

    public PartialTimestamp(TimeZone zone, Locale aLocale) {
        super(zone, aLocale);
        this.initializeModifiers();
        this.initializeFields();
    }

    private void initializeModifiers() {
        this.modifiers = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public int getModifier(int field) {
        return this.modifiers[field];
    }

    public void setModifier(int field, int value) {
        this.modifiers[field] = value;
    }

    private void initializeFields() {
        for (int count = 0; count < 17; ++count) {
            this.fields[count] = Integer.MAX_VALUE;
        }
    }

    public PartialTimestamp(int year, int month, int date, int hour, int minute) {
        this(TimeZone.getDefault(), Locale.getDefault());
        this.set(1, year);
        this.set(2, month);
        this.set(5, date);
        this.set(11, hour);
        this.set(12, minute);
    }

    public PartialTimestamp(int hour, int minute, int second) {
        this(TimeZone.getDefault(), Locale.getDefault());
        this.set(11, hour);
        this.set(12, minute);
        this.set(13, second);
    }

    public PartialTimestamp(int year, int month, int date, int hour, int minute, int second) {
        this(TimeZone.getDefault(), Locale.getDefault());
        this.set(1, year);
        this.set(2, month);
        this.set(5, date);
        this.set(11, hour);
        this.set(12, minute);
        this.set(13, second);
    }

    public void add(int field, int amount) {
        if (amount == 0) {
            return;
        }
        if (field < 0 || field >= 17) {
            throw new IllegalArgumentException("Invalid field");
        }
        if (!this.isSet(field)) {
            int n = field;
            this.modifiers[n] = this.modifiers[n] + amount;
        } else {
            this.adjustFields();
            if (field == 2 && this.isSet(2) && this.isSet(5)) {
                int newMonth;
                int month = this.internalGet(2);
                int dayOfMonth = this.internalGet(5);
                this.modifiers[1] = this.modifiers[1] + (month + amount) / 12;
                for (newMonth = (month + amount) % 12; newMonth < 0; newMonth += 12) {
                    this.modifiers[1] = this.modifiers[1] - 1;
                }
                if (month != 1 && newMonth != 1 && dayOfMonth > PartialTimestamp.getLengthOfMonth(newMonth, false)) {
                    this.myInternalSet(5, PartialTimestamp.getLengthOfMonth(newMonth, false));
                } else if (this.isSet(1) && this.isSet(0)) {
                    int fullYear = this.getYear();
                    int newMonthLength = PartialTimestamp.getLengthOfMonth(newMonth, PartialTimestamp.isLeapYear(fullYear + this.modifiers[1]));
                    if (dayOfMonth > newMonthLength) {
                        this.myInternalSet(5, newMonthLength);
                    }
                    this.myInternalSet(1, (fullYear += this.modifiers[1]) % 100);
                    this.myInternalSet(0, fullYear / 100);
                    this.modifiers[1] = 0;
                }
                this.set(2, newMonth);
            } else if (this.isSet(6) && this.isSet(1) && this.isSet(0) && (field == 1 || field == 0)) {
                boolean pinDay;
                int fullYear = this.getYear();
                int daysInYear = PartialTimestamp.getLengthOfYear(fullYear);
                int dayOfYear = this.internalGet(6);
                boolean bl = pinDay = dayOfYear == daysInYear;
                fullYear = field == 1 ? (fullYear += amount) : (fullYear += amount * 100);
                daysInYear = PartialTimestamp.getLengthOfYear(fullYear);
                if (pinDay && dayOfYear > daysInYear) {
                    this.myInternalSet(6, 365);
                }
                this.set(1, fullYear % 100);
                this.set(0, fullYear / 100);
            } else {
                super.set(field, this.internalGet(field) + amount);
            }
        }
        this.fieldsModified = true;
    }

    protected void computeFields() {
        TimeZone tz = this.getTimeZone();
        long localTime = this.time;
        int year = 1970;
        int numDays = 0;
        if (tz.inDaylightTime(new Date(localTime))) {
            this.set(16, tz.getDSTSavings());
        } else {
            this.set(16, 0);
        }
        this.set(15, tz.getOffset(localTime) - this.internalGet(16));
        if ((localTime += (long)(this.internalGet(16) + this.internalGet(15))) >= 94694400000L) {
            year = 1973;
            int num400 = (int)((localTime -= 94694400000L) / 12622780800000L);
            int num100 = (int)((localTime %= 12622780800000L) / 3155673600000L);
            int num4 = (int)((localTime %= 3155673600000L) / 126230400000L);
            int num1 = (int)((localTime %= 126230400000L) / 31536000000L);
            year += num400 * 400 + num100 * 100 + num4 * 4 + num1;
            numDays = (int)((localTime %= 31536000000L) / 86400000L);
            localTime %= 86400000L;
            if (num1 == 4 || num100 == 4) {
                numDays = 365;
                --year;
            }
        } else if (localTime >= 94608000000L) {
            year = 1972;
            numDays = 365;
        } else {
            int num1 = (int)(localTime / 31536000000L);
            numDays = (int)(localTime % 31536000000L);
            year = 1970 + num1;
        }
        this.setDateFields(++numDays, year);
        this.set(0, this.internalGet(0));
        this.set(1, this.internalGet(1));
        this.set(2, this.internalGet(2));
        this.set(5, this.internalGet(5));
        this.set(7, this.internalGet(7));
        this.set(6, this.internalGet(6));
        this.set(8, this.internalGet(8));
        this.set(4, this.internalGet(4));
        this.set(3, this.internalGet(3));
        this.set(11, (int)(localTime / 3600000L));
        this.set(10, this.internalGet(11) % 12);
        this.set(9, this.internalGet(11) / 12);
        this.set(12, (int)((localTime %= 3600000L) / 60000L));
        this.set(13, (int)((localTime %= 60000L) / 1000L));
        this.set(14, (int)(localTime %= 1000L));
        this.fieldsModified = false;
    }

    static boolean isLeapYear(int year) {
        return year % 400 == 0 || year % 100 != 0 && year % 4 == 0;
    }

    static int getTotalDays(int month, boolean isLeapYear) {
        int adjustment = isLeapYear ? 1 : 0;
        switch (month) {
            case 0: {
                return 31;
            }
            case 1: {
                return 59 + adjustment;
            }
            case 2: {
                return 90 + adjustment;
            }
            case 3: {
                return 120 + adjustment;
            }
            case 4: {
                return 151 + adjustment;
            }
            case 5: {
                return 181 + adjustment;
            }
            case 6: {
                return 212 + adjustment;
            }
            case 7: {
                return 243 + adjustment;
            }
            case 8: {
                return 273 + adjustment;
            }
            case 9: {
                return 304 + adjustment;
            }
            case 10: {
                return 334 + adjustment;
            }
            case 11: {
                return 365 + adjustment;
            }
        }
        return 0;
    }

    static int calculateMonth(int dayOfYear, boolean isLeapYear) {
        for (int month = 0; month <= 11; ++month) {
            if (dayOfYear > PartialTimestamp.getTotalDays(month, isLeapYear)) continue;
            return month;
        }
        throw new IllegalArgumentException();
    }

    public void set(int field, int value) {
        if (field < 0 || field >= 17) {
            throw new IllegalArgumentException("Invalid field");
        }
        switch (field) {
            case 10: 
            case 11: {
                this.lastHourSet = field;
                break;
            }
            case 6: {
                this.dayOfYearSet = this.getNextStamp();
                break;
            }
            case 3: {
                this.weekOfYearSet = this.getNextStamp();
                break;
            }
            case 4: {
                this.weekOfMonthSet = this.getNextStamp();
                break;
            }
            case 5: {
                this.dayOfMonthSet = this.getNextStamp();
                break;
            }
            case 8: {
                this.dayOfWeekInMonthSet = this.getNextStamp();
                break;
            }
            case 2: {
                this.monthSet = this.getNextStamp();
                break;
            }
            case 7: {
                this.dayOfWeekSet = this.getNextStamp();
            }
        }
        super.set(field, value);
        this.fieldsModified = true;
    }

    public int get(int field) {
        this.adjustFields();
        return this.internalGet(field);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void adjustFields() {
        boolean dayFieldChanged;
        int fullYear;
        int date;
        int millisecond;
        int second;
        int minute;
        int ampm;
        int hourOfDay;
        int hour;
        int weekOfYear;
        int dayOfYear;
        int dayOfWeekInMonth;
        int weekOfMonth;
        int dayOfMonth;
        int dayOfWeek;
        int month;
        int year;
        int century;
        block113: {
            int firstDayOfMonth;
            int lastDayOfMonth;
            int length;
            int lastDayFieldSet;
            boolean isLeapYear;
            block111: {
                block112: {
                    if (!this.fieldsModified) {
                        return;
                    }
                    century = this.internalGet(0);
                    year = this.internalGet(1);
                    month = this.internalGet(2);
                    int origDayOfWeek = dayOfWeek = this.internalGet(7);
                    dayOfMonth = this.internalGet(5);
                    weekOfMonth = this.internalGet(4);
                    dayOfWeekInMonth = this.internalGet(8);
                    dayOfYear = this.internalGet(6);
                    weekOfYear = this.internalGet(3);
                    hour = this.internalGet(10);
                    hourOfDay = this.internalGet(11);
                    ampm = this.internalGet(9);
                    minute = this.internalGet(12);
                    second = this.internalGet(13);
                    millisecond = this.internalGet(14);
                    int offset = this.internalGet(15);
                    boolean setHours = false;
                    boolean setDays = false;
                    date = 0;
                    fullYear = 0;
                    isLeapYear = false;
                    dayFieldChanged = false;
                    lastDayFieldSet = this.getLastDayFieldSet();
                    int lastTrueDayFieldSet = PartialTimestamp.getLastTrueDayFieldSet(lastDayFieldSet);
                    int lastWeekFieldSet = PartialTimestamp.getLastWeekFieldSet(lastDayFieldSet);
                    boolean lastDayFieldNeedsMonth = PartialTimestamp.lastDayFieldNeedsMonth(lastDayFieldSet);
                    if (this.isSet(14)) {
                        this.modifiers[14] = 0;
                        if ((millisecond += this.modifiers[14]) > 999 || millisecond < 0) {
                            if (!this.isLenient()) throw new IllegalArgumentException("Invalid MILLISECOND field");
                            this.modifiers[13] = this.modifiers[13] + millisecond / 1000;
                            if ((millisecond %= 1000) < 0) {
                                millisecond += 1000;
                                this.modifiers[13] = this.modifiers[13] - 1;
                            }
                        }
                    }
                    if (this.isSet(13)) {
                        this.modifiers[13] = 0;
                        if ((second += this.modifiers[13]) > 59 || second < 0) {
                            if (!this.isLenient()) throw new IllegalArgumentException("Invalid SECOND field");
                            this.modifiers[12] = this.modifiers[12] + second / 60;
                            if ((second %= 60) < 0) {
                                second += 60;
                                this.modifiers[12] = this.modifiers[12] - 1;
                            }
                        }
                    }
                    if (this.isSet(12)) {
                        this.modifiers[12] = 0;
                        if ((minute += this.modifiers[12]) > 59 || minute < 0) {
                            if (!this.isLenient()) throw new IllegalArgumentException("Invalid MINUTE field");
                            int n = this.lastHourSet;
                            this.modifiers[n] = this.modifiers[n] + minute / 60;
                            if ((minute %= 60) < 0) {
                                minute += 60;
                                int n2 = this.lastHourSet;
                                this.modifiers[n2] = this.modifiers[n2] - 1;
                            }
                        }
                    }
                    if (this.lastHourSet == 11 && this.isSet(11)) {
                        this.modifiers[11] = 0;
                        if ((hourOfDay += this.modifiers[11]) > 23 || hourOfDay < 0) {
                            if (!this.isLenient()) throw new IllegalArgumentException("Invalid HOUR_OF_DAY field");
                            int n = lastTrueDayFieldSet;
                            this.modifiers[n] = this.modifiers[n] + hourOfDay / 24;
                            if ((hourOfDay %= 24) < 0) {
                                hourOfDay += 24;
                                int n3 = lastTrueDayFieldSet;
                                this.modifiers[n3] = this.modifiers[n3] - 1;
                            }
                            if (this.isSet(10) && (hour = hourOfDay % 12) == 0) {
                                hour = 12;
                            }
                            if (this.isSet(9)) {
                                ampm = hourOfDay / 12;
                                this.modifiers[9] = 0;
                            }
                        }
                    } else if (this.lastHourSet == 10) {
                        int rawHour = hour;
                        this.modifiers[10] = 0;
                        if ((hour += this.modifiers[10]) > 12 || hour == 12 && rawHour < 12 || hour < 1) {
                            if (!this.isLenient()) throw new IllegalArgumentException("Invalid HOUR field");
                            this.modifiers[9] = this.modifiers[9] + hour / 12;
                            if ((hour %= 12) < 0) {
                                hour += 12;
                                this.modifiers[9] = this.modifiers[9] - 1;
                            }
                            if (hour == 0) {
                                hour = 12;
                            }
                        }
                    }
                    if (this.isSet(9)) {
                        this.modifiers[9] = 0;
                        if ((ampm += this.modifiers[9]) > 1 || ampm < 0) {
                            if (!this.isLenient()) throw new IllegalArgumentException("Invalid AM_PM field");
                            int n = lastTrueDayFieldSet;
                            this.modifiers[n] = this.modifiers[n] + ampm / 2;
                            if ((ampm %= 2) < 0) {
                                ampm += 2;
                                int n4 = lastTrueDayFieldSet;
                                this.modifiers[n4] = this.modifiers[n4] - 1;
                            }
                            if (this.isSet(10) && this.isSet(11)) {
                                hourOfDay = hour;
                                if (ampm == 1) {
                                    hourOfDay += 12;
                                }
                                if (hourOfDay == 24) {
                                    hourOfDay = 0;
                                }
                            }
                        }
                    }
                    if (this.isSet(2)) {
                        this.modifiers[2] = 0;
                        if ((month += this.modifiers[2]) < 0 || month > 11) {
                            if (!this.isLenient()) throw new IllegalArgumentException("Invalid MONTH field");
                            this.modifiers[1] = this.modifiers[1] + (month - 0) / 12;
                            if ((month = (month - 0) % 12 + 0) < 0) {
                                month += 12;
                                this.modifiers[1] = this.modifiers[1] - 1;
                            }
                        }
                    }
                    if (this.isSet(1)) {
                        this.modifiers[1] = 0;
                        if ((year += this.modifiers[1]) < 0 || year > 99) {
                            if (!this.isLenient()) throw new IllegalArgumentException("Invalid YEAR field");
                            this.modifiers[0] = this.modifiers[0] + year / 100;
                            if ((year %= 100) < 0) {
                                year += 100;
                                this.modifiers[0] = this.modifiers[0] - 1;
                            }
                        }
                    }
                    if (this.isSet(0)) {
                        this.modifiers[0] = 0;
                        if (!((century += this.modifiers[0]) >= 0 && century <= 0x7FFFFFFE || this.isLenient())) {
                            throw new IllegalArgumentException("Invalid CENTURY field");
                        }
                    }
                    if (this.isSet(1) && this.isSet(0)) {
                        fullYear = year + century * 100;
                        isLeapYear = PartialTimestamp.isLeapYear(fullYear);
                    }
                    if (this.isSet(7)) {
                        this.modifiers[7] = 0;
                        if ((dayOfWeek += this.modifiers[7]) < 1 || dayOfWeek > 7) {
                            if (this.isLenient() && lastWeekFieldSet != 0 && lastWeekFieldSet != 8) {
                                int n = lastWeekFieldSet;
                                this.modifiers[n] = this.modifiers[n] + (dayOfWeek - 1) / 7;
                                if ((dayOfWeek = (dayOfWeek - 1) % 7 + 1) < 1) {
                                    dayOfWeek += 7;
                                    int n5 = lastWeekFieldSet;
                                    this.modifiers[n5] = this.modifiers[n5] - 1;
                                }
                            } else if (!this.isLenient() && lastWeekFieldSet != 0 && lastWeekFieldSet != 8) {
                                throw new IllegalArgumentException("Invalid DAY_OF_WEEK field");
                            }
                        }
                    }
                    if (lastDayFieldSet != 5) break block111;
                    this.modifiers[5] = 0;
                    if ((dayOfMonth += this.modifiers[5]) < 1) break block112;
                    if (dayOfMonth <= PartialTimestamp.getLengthOfMonth(month, false)) break block113;
                }
                if (!this.isLenient()) throw new IllegalArgumentException("Invalid DAY_OF_MONTH field");
                if (this.isSet(2) && this.isSet(1) && this.isSet(0)) {
                    dayFieldChanged = true;
                    if (date < 1) {
                        do {
                            this.modifiers[1] = this.modifiers[1] - 1;
                        } while ((date += PartialTimestamp.getLengthOfYear(fullYear + this.modifiers[1])) < 1);
                    } else {
                        length = PartialTimestamp.getLengthOfYear(fullYear);
                        for (date = dayOfMonth + PartialTimestamp.getTotalDays(month - 1, isLeapYear); date > length; date -= length) {
                            this.modifiers[1] = this.modifiers[1] + 1;
                            length = PartialTimestamp.getLengthOfYear(fullYear + this.modifiers[1]);
                        }
                    }
                } else if (this.isSet(2) && dayOfMonth <= 0) {
                    int days = PartialTimestamp.getTotalDays(month - 1, false) + dayOfMonth;
                    if (month <= 1) {
                        if (days > -306 && days < 1) {
                            this.modifiers[1] = this.modifiers[1] - 1;
                            month = PartialTimestamp.calculateMonth(days += 365, false);
                            dayOfMonth = days - PartialTimestamp.getTotalDays(month - 1, false);
                        } else if (days < 1) {
                            dayOfMonth = 306 + days;
                            this.modifiers[1] = this.modifiers[1] - 1;
                            month = 2;
                        } else {
                            month = 0;
                            dayOfMonth = days;
                        }
                    } else if (month > 2) {
                        if (days > 59) {
                            month = PartialTimestamp.calculateMonth(days, false);
                            dayOfMonth = days - PartialTimestamp.getTotalDays(month - 1, false);
                        } else {
                            dayOfMonth = days - 59;
                            month = 2;
                        }
                    }
                    if (this.isSet(1) && this.modifiers[1] != 0) {
                        this.modifiers[1] = 0;
                        year = (fullYear += this.modifiers[1]) % 100;
                        century = fullYear / 100;
                    }
                } else if (this.isSet(2)) {
                    if (month == 0) {
                        dayOfMonth -= PartialTimestamp.getLengthOfMonth(0, false);
                        ++month;
                    } else if (month > 1) {
                        if (dayOfMonth < 365 - PartialTimestamp.getTotalDays(month - 1, false)) {
                            month = PartialTimestamp.calculateMonth(dayOfMonth + PartialTimestamp.getTotalDays(month - 1, false), false);
                            dayOfMonth -= PartialTimestamp.getTotalDays(month - 1, false);
                        } else if (dayOfMonth < 396 - PartialTimestamp.getTotalDays(month - 1, false)) {
                            dayOfMonth -= 365 - PartialTimestamp.getTotalDays(month - 1, false);
                            month = 0;
                        } else {
                            dayOfMonth -= 396 - PartialTimestamp.getTotalDays(month - 1, false);
                            month = 1;
                        }
                    }
                }
                break block113;
            }
            if (lastDayFieldSet == 4) {
                this.modifiers[4] = 0;
                if ((weekOfMonth += this.modifiers[4]) < 1 || weekOfMonth > 4) {
                    if (!this.isLenient()) throw new IllegalArgumentException("Invalid WEEK_OF_MONTH field");
                    if (this.isSet(2) && this.isSet(7) && this.isSet(1) && this.isSet(0)) {
                        date += PartialTimestamp.getTotalDays(month - 1, isLeapYear);
                        dayFieldChanged = true;
                        if (weekOfMonth < 1) {
                            lastDayOfMonth = PartialTimestamp.calculateDayOfWeek(PartialTimestamp.getLengthOfMonth(month, isLeapYear), month, fullYear);
                            date += (weekOfMonth - 1) * 7 + (dayOfWeek - lastDayOfMonth);
                            int length2 = PartialTimestamp.getLengthOfYear(fullYear);
                            while (date < 1) {
                                date += length2;
                                this.modifiers[1] = this.modifiers[1] - 1;
                                length2 = PartialTimestamp.getLengthOfYear(fullYear + this.modifiers[1]);
                            }
                        } else {
                            firstDayOfMonth = PartialTimestamp.calculateDayOfWeek(1, month, fullYear);
                            date += (weekOfMonth - 1) * 7 + (dayOfWeek - firstDayOfMonth) + 1;
                            int length3 = PartialTimestamp.getLengthOfYear(fullYear);
                            while (date > length3) {
                                date -= length3;
                                this.modifiers[1] = this.modifiers[1] + 1;
                                length3 = PartialTimestamp.getLengthOfYear(fullYear + this.modifiers[1]);
                            }
                        }
                    }
                }
            } else if (lastDayFieldSet == 8) {
                this.modifiers[8] = 0;
                if ((dayOfWeekInMonth += this.modifiers[8]) < -4 || dayOfWeekInMonth > 4 || dayOfWeekInMonth == 0 || dayOfWeek < 1 || dayOfWeek > 7) {
                    if (!this.isLenient()) throw new IllegalArgumentException("Invalid DAY_OF_WEEK_IN_MONTH field");
                    if (this.isSet(2) && this.isSet(7) && this.isSet(1) && this.isSet(0)) {
                        int length4;
                        int diff;
                        date = PartialTimestamp.getTotalDays(month - 1, isLeapYear);
                        dayFieldChanged = true;
                        if (dayOfWeekInMonth < 0) {
                            lastDayOfMonth = PartialTimestamp.calculateDayOfWeek(PartialTimestamp.getLengthOfMonth(month, isLeapYear), month, fullYear);
                            diff = lastDayOfMonth + 1;
                            if (diff > 7) {
                                diff -= 7;
                            }
                            if ((diff = dayOfWeek - diff) < 1) {
                                diff += 7;
                            }
                            date += dayOfWeekInMonth * 7 + 1 + diff + PartialTimestamp.getLengthOfMonth(month, isLeapYear);
                            length4 = PartialTimestamp.getLengthOfYear(fullYear);
                            while (date < 1) {
                                date += length4;
                                this.modifiers[1] = this.modifiers[1] - 1;
                                length4 = PartialTimestamp.getLengthOfYear(fullYear + this.modifiers[1]);
                            }
                        } else {
                            firstDayOfMonth = PartialTimestamp.calculateDayOfWeek(1, month, fullYear);
                            diff = dayOfWeek - firstDayOfMonth;
                            if (diff < 1) {
                                diff += 7;
                            }
                            length4 = PartialTimestamp.getLengthOfYear(fullYear);
                            if ((date += (dayOfWeekInMonth - 1) * 7 + diff + 1) < 1) {
                                this.modifiers[1] = this.modifiers[1] - 1;
                                date += PartialTimestamp.getLengthOfYear(fullYear + this.modifiers[1]);
                            } else {
                                while (date > length4) {
                                    date -= length4;
                                    this.modifiers[1] = this.modifiers[1] + 1;
                                    length4 = PartialTimestamp.getLengthOfYear(fullYear + this.modifiers[1]);
                                }
                            }
                        }
                        if (dayOfWeek < 1) {
                            while ((dayOfWeek += 7) < 1) {
                            }
                        } else {
                            while (dayOfWeek > 7) {
                                dayOfWeek -= 7;
                            }
                        }
                    }
                }
            } else if (lastDayFieldSet == 6) {
                this.modifiers[6] = 0;
                if ((dayOfYear += this.modifiers[6]) < 1 || dayOfYear > 365) {
                    if (!this.isLenient()) throw new IllegalArgumentException("Invalid DAY_OF_YEAR field");
                    if (this.isSet(1) && this.isSet(0)) {
                        dayFieldChanged = true;
                        if (date < 1) {
                            do {
                                this.modifiers[1] = this.modifiers[1] - 1;
                            } while ((date += PartialTimestamp.getLengthOfYear(fullYear + this.modifiers[1])) < 1);
                        } else {
                            length = PartialTimestamp.getLengthOfYear(fullYear);
                            for (date = dayOfYear; date > length; date -= length) {
                                this.modifiers[1] = this.modifiers[1] + 1;
                                length = PartialTimestamp.getLengthOfYear(fullYear + this.modifiers[1]);
                            }
                        }
                    }
                }
            } else if (lastDayFieldSet == 3) {
                this.modifiers[3] = 0;
                if ((weekOfYear += this.modifiers[3]) < 1 || weekOfYear > 52) {
                    if (!this.isLenient()) throw new IllegalArgumentException("Invalid WEEK_OF_YEAR field");
                    if (this.isSet(7) && this.isSet(1) && this.isSet(0)) {
                        int firstDay = PartialTimestamp.calculateDayOfWeek(1, 0, fullYear);
                        dayFieldChanged = true;
                        if (date < 1) {
                            do {
                                this.modifiers[1] = this.modifiers[1] - 1;
                            } while ((date += PartialTimestamp.getLengthOfYear(fullYear + this.modifiers[1])) < 1);
                        } else {
                            int length5 = PartialTimestamp.getLengthOfYear(fullYear);
                            for (date = weekOfYear * 7 - (7 - dayOfWeek) - (firstDay - 1); date > length5; date -= length5) {
                                this.modifiers[1] = this.modifiers[1] + 1;
                                length5 = PartialTimestamp.getLengthOfYear(fullYear + this.modifiers[1]);
                            }
                        }
                    }
                }
            }
        }
        if (dayFieldChanged) {
            if (this.modifiers[1] != 0) {
                fullYear += this.modifiers[1];
                this.modifiers[1] = 0;
            }
            this.setDateFields(date, fullYear);
        } else {
            this.myInternalSet(0, century);
            this.myInternalSet(1, year);
            this.myInternalSet(2, month);
            this.myInternalSet(7, dayOfWeek);
            this.myInternalSet(5, dayOfMonth);
            this.myInternalSet(6, dayOfYear);
            this.myInternalSet(8, dayOfWeekInMonth);
            this.myInternalSet(4, weekOfMonth);
            this.myInternalSet(3, weekOfYear);
        }
        this.myInternalSet(14, millisecond);
        this.myInternalSet(13, second);
        this.myInternalSet(12, minute);
        this.myInternalSet(10, hour);
        this.myInternalSet(9, ampm);
        this.myInternalSet(11, hourOfDay);
        this.fieldsModified = false;
    }

    private static int getLastTrueDayFieldSet(int lastDayFieldSet) {
        int lastTrueDayFieldSet = 0;
        switch (lastDayFieldSet) {
            case 3: 
            case 4: 
            case 8: {
                lastTrueDayFieldSet = 7;
                break;
            }
            case 6: {
                lastTrueDayFieldSet = 6;
                break;
            }
            default: {
                lastTrueDayFieldSet = 5;
            }
        }
        return lastTrueDayFieldSet;
    }

    private static int getLastWeekFieldSet(int lastDayFieldSet) {
        int lastWeekFieldSet = 0;
        switch (lastDayFieldSet) {
            case 4: {
                lastWeekFieldSet = 4;
                break;
            }
            case 3: {
                lastWeekFieldSet = 3;
                break;
            }
            case 8: {
                lastWeekFieldSet = 8;
                break;
            }
            default: {
                lastWeekFieldSet = 0;
            }
        }
        return lastWeekFieldSet;
    }

    private static boolean lastDayFieldNeedsMonth(int lastDayFieldSet) {
        boolean lastDayFieldNeedsMonth = false;
        if (lastDayFieldSet == 5 || lastDayFieldSet == 4 || lastDayFieldSet == 8) {
            lastDayFieldNeedsMonth = true;
        }
        return lastDayFieldNeedsMonth;
    }

    private void setDateFields(int dayOfYear, int year) {
        int month = PartialTimestamp.calculateMonth(dayOfYear, PartialTimestamp.isLeapYear(year));
        int date = dayOfYear - PartialTimestamp.getTotalDays(month - 1, PartialTimestamp.isLeapYear(year));
        int dayOfWeek = PartialTimestamp.calculateDayOfWeek(date, month, year);
        this.myInternalSet(5, date);
        this.myInternalSet(7, dayOfWeek);
        this.setWeekOfMonth(dayOfWeek, date);
        this.setDayOfWeekInMonth(date);
        this.myInternalSet(6, dayOfYear);
        this.setWeekOfYear(dayOfYear, PartialTimestamp.calculateDayOfWeek(1, 0, year));
        this.myInternalSet(2, month);
        this.myInternalSet(1, year % 100);
        this.myInternalSet(0, year / 100);
    }

    private void setWeekOfYear(int dayOfYear, int firstDay) {
        int leading = (8 - firstDay) % 7;
        int trailing = (dayOfYear -= leading) % 7;
        int weekOfYear = dayOfYear / 7 + (leading > 0 ? 1 : 0) + (trailing > 0 ? 1 : 0);
        this.myInternalSet(3, weekOfYear);
    }

    private void setDayOfWeekInMonth(int date) {
        int dayOfWeekInMonth = date / 7;
        if (date % 7 != 0) {
            ++dayOfWeekInMonth;
        }
        this.myInternalSet(8, dayOfWeekInMonth);
    }

    private void setWeekOfMonth(int dayOfWeek, int date) {
        int firstDayOfMonth = dayOfWeek - (date - 1) % 7;
        if (firstDayOfMonth < 1) {
            firstDayOfMonth += 7;
        }
        int leading = (8 - firstDayOfMonth) % 7;
        int newDays = date - leading;
        int trailing = newDays % 7;
        int weekOfMonth = newDays / 7 + (trailing > 0 ? 1 : 0) + (leading > 0 ? 1 : 0);
        this.myInternalSet(4, weekOfMonth);
    }

    static int calculateDayOfWeek(int date, int month, int year) {
        int dayOfWeek = 4;
        int days = PartialTimestamp.getTotalDays(month - 1, PartialTimestamp.isLeapYear(year));
        dayOfWeek = year > 2000 ? (dayOfWeek += (year - 1969) / 4 * 5 - (year - 2001) / 100 + (year - 2001) / 400 + (year - 1969) % 4) : (dayOfWeek += (year - 1969) / 4 * 5 + (year - 1969) % 4);
        dayOfWeek += days + date - 1;
        dayOfWeek = (dayOfWeek - 1) % 7 + 1;
        return dayOfWeek;
    }

    protected void computeTime() {
        int firstSet = -1;
        if (!(this.isSet(11) || this.isSet(10) || this.isSet(9))) {
            throw new IllegalArgumentException("HOUR_OF_DAY is a required field.");
        }
        if (!this.isSet(12)) {
            throw new IllegalArgumentException("MINUTE is a required field.");
        }
        this.adjustFields();
        Calendar then = Calendar.getInstance(this.getTimeZone());
        for (int count = 2; count < DRMAA_FIELDS.length; ++count) {
            if (this.isSet(DRMAA_FIELDS[count])) {
                then.set(DRMAA_FIELDS[count], this.internalGet(DRMAA_FIELDS[count]));
                if (firstSet != -1) continue;
                firstSet = DRMAA_FIELDS[count];
                continue;
            }
            if (DRMAA_FIELDS[count] != 13) continue;
            then.set(DRMAA_FIELDS[count], 0);
        }
        if (this.isSet(1) && this.isSet(0)) {
            then.set(1, this.internalGet(1) + this.internalGet(0) * 100);
            firstSet = 0;
        } else if (this.isSet(1)) {
            then.set(1, this.internalGet(1) + (then.get(1) - then.get(1) % 100));
            firstSet = 1;
        } else if (this.isSet(0)) {
            then.set(1, then.get(1) % 100 + this.internalGet(0) * 100);
            firstSet = 0;
        }
        then.set(14, 0);
        if (then.getTimeInMillis() < System.currentTimeMillis()) {
            if (firstSet == 1) {
                then.add(PartialTimestamp.getNextField(firstSet), 100);
            } else if (firstSet != 0) {
                then.add(PartialTimestamp.getNextField(firstSet), 1);
            }
        }
        this.time = then.getTimeInMillis();
    }

    private static int getNextField(int field) {
        int nextField = -1;
        switch (field) {
            case 1: 
            case 2: 
            case 3: {
                nextField = 1;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                nextField = 2;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                nextField = 6;
            }
        }
        return nextField;
    }

    public int getGreatestMinimum(int field) {
        switch (field) {
            case 1: {
                return 70;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return -4;
            }
        }
        return this.getMinimum(field);
    }

    public int getLeastMaximum(int field) {
        switch (field) {
            case 3: {
                return 52;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 28;
            }
            case 6: {
                return 365;
            }
            case 8: {
                return 4;
            }
        }
        return this.getMaximum(field);
    }

    public int getMaximum(int field) {
        switch (field) {
            case 1: {
                return 99;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 54;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 366;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 5;
            }
            case 9: {
                return 1;
            }
            case 10: {
                return 11;
            }
            case 11: {
                return 23;
            }
            case 12: {
                return 59;
            }
            case 13: {
                return 59;
            }
            case 14: {
                return 999;
            }
            case 15: {
                return 12;
            }
            case 16: {
                return 1;
            }
            case 0: {
                return Integer.MAX_VALUE;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getMinimum(int field) {
        switch (field) {
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 1;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 0;
            }
            case 9: {
                return 0;
            }
            case 10: {
                return 0;
            }
            case 11: {
                return 0;
            }
            case 12: {
                return 0;
            }
            case 13: {
                return 0;
            }
            case 14: {
                return 0;
            }
            case 15: {
                return -12;
            }
            case 16: {
                return 0;
            }
            case 0: {
                return 19;
            }
        }
        throw new IllegalArgumentException();
    }

    public void roll(int field, boolean up) {
        this.roll(field, up ? 1 : -1);
    }

    public void roll(int field, int amount) {
        int length;
        if (amount == 0) {
            return;
        }
        int min = 0;
        int max = 0;
        int gap = 0;
        boolean dayAtEnd = false;
        if (field < 0 || field >= 17 || !this.isSet(field)) {
            if (!this.isSet(field)) {
                throw new IllegalArgumentException("Invalid field");
            }
            throw new IllegalArgumentException("Cannot roll unset fields");
        }
        this.adjustFields();
        min = this.getMinimum(field);
        max = this.getMaximum(field);
        switch (field) {
            case 2: {
                boolean isLeapYear = PartialTimestamp.isLeapYear(this.getYear());
                length = PartialTimestamp.getLengthOfMonth(this.internalGet(2), isLeapYear);
                dayAtEnd = this.isSet(5) && this.internalGet(5) == length;
                break;
            }
            case 1: {
                int length2 = PartialTimestamp.getLengthOfYear(this.getYear());
                dayAtEnd = this.isSet(6) && this.internalGet(6) == length2;
                break;
            }
            case 3: {
                max = this.isSet(1) && this.isSet(0) ? this.getActualMaximum(field) : 53;
                min = this.getActualMinimum(field);
                break;
            }
            case 4: {
                max = this.isSet(1) && this.isSet(0) ? this.getActualMaximum(field) : 5;
                min = this.getActualMinimum(field);
                break;
            }
            case 8: {
                int dayOfWeekInMonth = this.internalGet(field);
                if (dayOfWeekInMonth < 0) {
                    max = this.getActualMinimum(field);
                    max = -max;
                    if (this.isSet(1) && this.isSet(0)) {
                        min = this.getActualMaximum(field);
                        min = -min;
                        break;
                    }
                    min = -5;
                    break;
                }
                max = this.isSet(1) && this.isSet(0) ? this.getActualMaximum(field) : 5;
                min = this.getActualMinimum(field);
                break;
            }
            case 0: 
            case 15: 
            case 16: {
                throw new IllegalArgumentException("This field cannot be rolled");
            }
            default: {
                max = this.getActualMaximum(field);
                min = this.getActualMinimum(field);
            }
        }
        int value = this.internalGet(field) + amount;
        gap = max - min + 1;
        value = (value - min) % gap;
        if (value < 0) {
            value += gap;
        }
        this.set(field, value += min);
        if (dayAtEnd) {
            if (field == 2) {
                boolean isLeapYear = PartialTimestamp.isLeapYear(this.getYear());
                int length3 = PartialTimestamp.getLengthOfMonth(this.internalGet(2), isLeapYear);
                this.myInternalSet(5, length3);
            } else {
                length = PartialTimestamp.getLengthOfYear(this.getYear());
                this.myInternalSet(6, length);
            }
        }
        this.fieldsModified = true;
    }

    private synchronized int getNextStamp() {
        if (this.dayStamp == Integer.MAX_VALUE) {
            int min = Math.min(this.monthSet, this.dayOfWeekSet);
            min = Math.min(min, this.dayOfMonthSet);
            min = Math.min(min, this.dayOfWeekInMonthSet);
            min = Math.min(min, this.dayOfYearSet);
            min = Math.min(min, this.weekOfMonthSet);
            min = Math.min(min, this.weekOfYearSet);
            this.monthSet -= min;
            this.dayOfWeekSet -= min;
            this.dayOfMonthSet -= min;
            this.dayOfWeekInMonthSet -= min;
            this.dayOfYearSet -= min;
            this.weekOfMonthSet -= min;
            this.weekOfYearSet -= min;
            int max = Math.max(this.monthSet, this.dayOfWeekSet);
            max = Math.max(max, this.dayOfMonthSet);
            max = Math.max(max, this.dayOfWeekInMonthSet);
            max = Math.max(max, this.dayOfYearSet);
            max = Math.max(max, this.weekOfMonthSet);
            max = Math.max(max, this.weekOfYearSet);
            this.dayStamp = max + 1;
        }
        return this.dayStamp++;
    }

    private int getLastDayFieldSet() {
        int[] best = null;
        int[] thisBest = null;
        int bestField = -1;
        if (this.isSet(5)) {
            thisBest = new int[]{this.monthSet, this.dayOfMonthSet};
            if (best == null || PartialTimestamp.compareStamps(thisBest, best) == 1) {
                best = thisBest;
                bestField = 5;
            }
        }
        if (this.isSet(4)) {
            thisBest = new int[]{this.monthSet, this.weekOfMonthSet, this.dayOfWeekSet};
            if (best == null || PartialTimestamp.compareStamps(thisBest, best) == 1) {
                best = thisBest;
                bestField = 4;
            }
        }
        if (this.isSet(8)) {
            thisBest = new int[]{this.monthSet, this.dayOfWeekInMonthSet, this.dayOfWeekSet};
            if (best == null || PartialTimestamp.compareStamps(thisBest, best) == 1) {
                best = thisBest;
                bestField = 8;
            }
        }
        if (this.isSet(6)) {
            thisBest = new int[]{this.dayOfYearSet};
            if (best == null || PartialTimestamp.compareStamps(thisBest, best) == 1) {
                best = thisBest;
                bestField = 6;
            }
        }
        if (this.isSet(3)) {
            thisBest = new int[]{this.weekOfYearSet, this.dayOfWeekSet};
            if (best == null || PartialTimestamp.compareStamps(thisBest, best) == 1) {
                bestField = 3;
            }
        }
        return bestField;
    }

    private static int compareStamps(int[] stamp1, int[] stamp2) {
        int count;
        Arrays.sort(stamp1);
        Arrays.sort(stamp2);
        int comparison = 0;
        int length1 = stamp1.length;
        int length2 = stamp2.length;
        boolean unset1 = false;
        boolean unset2 = false;
        for (count = 1; count <= length1 && stamp1[length1 - count] == Integer.MAX_VALUE; ++count) {
        }
        unset1 = count > 1;
        length1 -= count;
        for (count = 1; count <= length2 && stamp2[length2 - count] == Integer.MAX_VALUE; ++count) {
        }
        unset2 = count > 1;
        length2 -= count;
        if (!unset1 && unset2) {
            comparison = 1;
        } else if (unset1 && !unset2) {
            comparison = -1;
        } else if (stamp1[length1] == Integer.MAX_VALUE && stamp2[length2] == Integer.MAX_VALUE) {
            comparison = 0;
        } else if (stamp1[length1] == Integer.MAX_VALUE && stamp2[length2] != Integer.MAX_VALUE) {
            comparison = -1;
        } else if (stamp1[length1] != Integer.MAX_VALUE && stamp2[length2] == Integer.MAX_VALUE) {
            comparison = -1;
        } else {
            count = 0;
            while (length1 - count >= 0 && length2 - count >= 0) {
                if (stamp1[length1 - count] > stamp2[length2 - count]) {
                    comparison = 1;
                    break;
                }
                if (stamp1[length1 - count] < stamp2[length2 - count]) {
                    comparison = -1;
                    break;
                }
                ++count;
            }
        }
        return comparison;
    }

    static int getLengthOfMonth(int month, boolean isLeapYear) {
        if (month == 0 || month == 2 || month == 4 || month == 6 || month == 7 || month == 9 || month == 11) {
            return 31;
        }
        if (month == 3 || month == 5 || month == 8 || month == 10) {
            return 30;
        }
        if (isLeapYear) {
            return 29;
        }
        return 28;
    }

    static int getLengthOfYear(int year) {
        if (PartialTimestamp.isLeapYear(year)) {
            return 366;
        }
        return 365;
    }

    protected void myInternalSet(int field, int value) {
        this.fields[field] = value;
    }

    public int getActualMinimum(int field) {
        switch (field) {
            case 1: {
                if (!this.isSet(0) || this.internalGet(0) != 19) break;
                return 70;
            }
            case 7: {
                if (!this.isSet(0) || this.internalGet(0) != 19 || !this.isSet(1) || this.internalGet(1) != 70 || !this.isSet(2) || this.internalGet(2) != 0 || !(this.isSet(5) && this.internalGet(5) <= 3 || this.isSet(4) && this.internalGet(4) == 1 || this.isSet(8) && (this.internalGet(8) == 1 || this.internalGet(8) == -5) || this.isSet(6) && this.internalGet(6) <= 3) && (!this.isSet(3) || this.internalGet(3) != 1)) break;
                return 5;
            }
        }
        return this.getMinimum(field);
    }

    public int getActualMaximum(int field) {
        switch (field) {
            case 3: {
                if (this.isSet(1) && this.isSet(0) && this.isSet(2) && PartialTimestamp.isLeapYear(this.getYear()) && PartialTimestamp.calculateDayOfWeek(1, 0, this.internalGet(1)) == 1) {
                    return 54;
                }
                return 53;
            }
            case 4: 
            case 8: {
                if (this.isSet(2) && this.isSet(1) && this.isSet(0)) {
                    int numWeeks = 4;
                    int month = this.internalGet(2);
                    int year = this.getYear();
                    if (PartialTimestamp.calculateDayOfWeek(1, month, year) != 1) {
                        ++numWeeks;
                    }
                    if (PartialTimestamp.calculateDayOfWeek(PartialTimestamp.getLengthOfMonth(month, PartialTimestamp.isLeapYear(year)), month, year) != 7) {
                        ++numWeeks;
                    }
                    return numWeeks;
                }
                if (this.isSet(2) && this.internalGet(2) == 1) {
                    return 5;
                }
                return 6;
            }
            case 5: {
                if (this.isSet(2) && this.isSet(1) && this.isSet(0)) {
                    return PartialTimestamp.getLengthOfMonth(this.internalGet(2), PartialTimestamp.isLeapYear(this.getYear()));
                }
                if (this.isSet(2)) {
                    return PartialTimestamp.getLengthOfMonth(this.internalGet(2), false);
                }
                return 31;
            }
            case 6: {
                if (this.isSet(1) && this.isSet(0) && PartialTimestamp.isLeapYear(this.getYear())) {
                    return 366;
                }
                return 365;
            }
        }
        return this.getMaximum(field);
    }

    private int getYear() {
        return this.internalGet(1) + this.internalGet(0) * 100;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PartialTimestamp)) {
            return false;
        }
        PartialTimestamp pt = (PartialTimestamp)obj;
        for (int field = 0; field < 17; ++field) {
            if (this.isSet(field) && pt.isSet(field) && this.get(field) != pt.get(field)) {
                return false;
            }
            if (this.isSet(field) != pt.isSet(field)) {
                return false;
            }
            if (this.getModifier(field) == pt.getModifier(field)) continue;
            return false;
        }
        return this.lastHourSet == pt.lastHourSet && this.getLastDayFieldSet() == pt.getLastDayFieldSet();
    }

    public Object clone() {
        PartialTimestamp pt = (PartialTimestamp)super.clone();
        pt.modifiers = new int[17];
        System.arraycopy(this.modifiers, 0, pt.modifiers, 0, 17);
        pt.lastHourSet = this.lastHourSet;
        pt.fieldsModified = this.fieldsModified;
        pt.dayOfMonthSet = this.dayOfMonthSet;
        pt.dayOfWeekInMonthSet = this.dayOfWeekInMonthSet;
        pt.dayOfYearSet = this.dayOfYearSet;
        pt.weekOfMonthSet = this.weekOfMonthSet;
        pt.weekOfYearSet = this.weekOfYearSet;
        pt.monthSet = this.monthSet;
        pt.dayStamp = this.dayStamp;
        return pt;
    }
}

