/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.servlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class RunR {
    private String rPath;
    private final File wrkDir;
    private final File rScript;

    public RunR(String rPath, File wrkDir, File rScript) {
        this.rPath = rPath;
        this.wrkDir = wrkDir;
        this.rScript = rScript;
    }

    public void runR() throws Exception {
        ProcessBuilder pb = new ProcessBuilder(this.rPath, "--vanilla");
        pb.directory(this.wrkDir);
        pb.redirectErrorStream(true);
        Process proc = pb.start();
        System.out.println("Process started");
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(proc.getOutputStream()));
        writer.print("source(\"" + this.rScript.getPath().replace('\\', '/') + "\")");
        writer.close();
        StreamCatcher oStream = new StreamCatcher(proc.getInputStream(), true);
        proc.waitFor();
        System.out.println("Waiting for process");
        while (oStream.isAlive()) {
            Thread.sleep(10L);
        }
        System.out.println("Completed process");
    }

    private static class StreamCatcher
    extends Thread {
        protected BufferedReader reader = null;
        protected boolean showOutput = false;

        public StreamCatcher(InputStream in, boolean showOutput) {
            this.reader = new BufferedReader(new InputStreamReader(in));
            this.showOutput = showOutput;
            this.start();
        }

        @Override
        public void run() {
            try {
                String line = this.reader.readLine();
                while (line != null) {
                    if (this.showOutput) {
                        System.out.println(line);
                    }
                    line = this.reader.readLine();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

