/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.brapi;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import jhi.brapi.api.BrapiBaseResource;
import jhi.brapi.api.BrapiListResource;
import jhi.brapi.api.Metadata;
import jhi.brapi.api.authentication.BrapiSessionToken;
import jhi.brapi.api.authentication.BrapiTokenPost;
import jhi.brapi.api.calls.BrapiCall;
import jhi.brapi.api.genomemaps.BrapiGenomeMap;
import jhi.brapi.api.genomemaps.BrapiMapMetaData;
import jhi.brapi.api.genomemaps.BrapiMarkerPosition;
import jhi.brapi.api.markerprofiles.BrapiAlleleMatrix;
import jhi.brapi.api.markerprofiles.BrapiMarkerProfile;
import jhi.brapi.api.studies.BrapiStudies;
import jhi.brapi.api.studies.BrapiStudiesPost;
import jhi.brapi.client.Pager;
import jhi.brapi.client.RetrofitService;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.io.brapi.CallsUtils;
import jhi.flapjack.io.brapi.XmlBrapiProvider;
import jhi.flapjack.io.brapi.XmlResource;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class BrapiClient {
    private RetrofitService service;
    private String baseURL;
    private XmlResource resource;
    private String username;
    private String password;
    private String mapID;
    private String studyID;
    private String methodID;
    private CallsUtils callsUtils;
    private String authToken;

    public void initService() throws Exception {
        this.baseURL = this.resource.getUrl();
        this.baseURL = this.baseURL.endsWith("/") ? this.baseURL : this.baseURL + "/";
        this.service = this.createService(this.baseURL, null);
    }

    private RetrofitService createService(String baseURL, String authToken) {
        Interceptor inter = this.buildInterceptor(authToken);
        OkHttpClient httpClient = new OkHttpClient.Builder().readTimeout(60L, TimeUnit.SECONDS).connectTimeout(60L, TimeUnit.SECONDS).addNetworkInterceptor(inter).build();
        try {
            httpClient = this.initCertificate(httpClient, this.resource.getCertificate());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.buildService(baseURL, httpClient);
    }

    private Interceptor buildInterceptor(String authToken) {
        String bearer = "Bearer %s";
        Interceptor inter = chain -> {
            Request original = chain.request();
            if (original.header("Authorization") != null || authToken == null || authToken.isEmpty()) {
                return chain.proceed(original);
            }
            Request next = original.newBuilder().header("Authorization", String.format(bearer, authToken)).build();
            return chain.proceed(next);
        };
        return inter;
    }

    private RetrofitService buildService(String baseURL, OkHttpClient client) {
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseURL).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).client(client).build();
        return (RetrofitService)retrofit.create(RetrofitService.class);
    }

    private String enc(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public void getCalls() throws Exception {
        ArrayList<BrapiCall> calls = new ArrayList<BrapiCall>();
        Pager pager = new Pager();
        while (pager.isPaging()) {
            BrapiListResource br = (BrapiListResource)this.service.getCalls(null, pager.getPageSize(), pager.getPage()).execute().body();
            calls.addAll(br.data());
            pager.paginate(br.getMetadata());
        }
        this.callsUtils = new CallsUtils(calls);
        if (!this.callsUtils.validate()) {
            throw new Exception("/calls not valid");
        }
    }

    public boolean hasToken() {
        return this.callsUtils.hasToken();
    }

    public boolean hasAlleleMatrixSearchTSV() {
        return this.callsUtils.hasAlleleMatrixSearchTSV();
    }

    public boolean hasAlleleMatrixSearchFlapjack() {
        return this.callsUtils.hasAlleleMatrixSearchFlapjack();
    }

    public boolean hasMapsMapDbId() {
        return this.callsUtils.hasMapsMapDbId();
    }

    public boolean doAuthentication() throws Exception {
        if (this.username == null && this.password == null) {
            return false;
        }
        BrapiTokenPost tokenPost = new BrapiTokenPost(this.enc(this.username), this.enc(this.password), "password", "flapjack");
        BrapiSessionToken token = (BrapiSessionToken)this.service.getAuthToken(tokenPost).execute().body();
        if (token == null) {
            return false;
        }
        this.authToken = token.getSessionToken();
        this.service = this.createService(this.baseURL, token.getSessionToken());
        return true;
    }

    public List<BrapiGenomeMap> getMaps() throws Exception {
        ArrayList<BrapiGenomeMap> list = new ArrayList<BrapiGenomeMap>();
        Pager pager = new Pager();
        while (pager.isPaging()) {
            BrapiListResource br = (BrapiListResource)this.service.getMaps(null, null, pager.getPageSize(), pager.getPage()).execute().body();
            list.addAll(br.data());
            pager.paginate(br.getMetadata());
        }
        return list;
    }

    public List<BrapiMarkerPosition> getMapMarkerData() throws Exception {
        ArrayList<BrapiMarkerPosition> list = new ArrayList<BrapiMarkerPosition>();
        Pager pager = new Pager();
        while (pager.isPaging()) {
            BrapiListResource br = (BrapiListResource)this.service.getMapMarkerData(this.enc(this.mapID), null, pager.getPageSize(), pager.getPage()).execute().body();
            list.addAll(br.data());
            pager.paginate(br.getMetadata());
        }
        return list;
    }

    public BrapiMapMetaData getMapMetaData() throws Exception {
        BrapiBaseResource br = (BrapiBaseResource)this.service.getMapMetaData(this.enc(this.mapID)).execute().body();
        return (BrapiMapMetaData)br.getResult();
    }

    public List<BrapiStudies> getStudies() throws Exception {
        ArrayList<BrapiStudies> list = new ArrayList<BrapiStudies>();
        Pager pager = new Pager();
        while (pager.isPaging()) {
            BrapiListResource br = (BrapiListResource)this.service.getStudies("genotype", pager.getPageSize(), pager.getPage()).execute().body();
            list.addAll(br.data());
            pager.paginate(br.getMetadata());
        }
        return list;
    }

    public List<BrapiStudies> getStudiesByPost() throws Exception {
        ArrayList<BrapiStudies> list = new ArrayList<BrapiStudies>();
        Pager pager = new Pager();
        BrapiStudiesPost post = new BrapiStudiesPost();
        post.setStudyType("genotype");
        while (pager.isPaging()) {
            BrapiListResource br = (BrapiListResource)this.service.getStudiesPost(post).execute().body();
            list.addAll(br.data());
            pager.paginate(br.getMetadata());
        }
        return list;
    }

    public List<BrapiMarkerProfile> getMarkerProfiles() throws Exception {
        ArrayList<BrapiMarkerProfile> list = new ArrayList<BrapiMarkerProfile>();
        Pager pager = new Pager();
        while (pager.isPaging()) {
            BrapiListResource br = (BrapiListResource)this.service.getMarkerProfiles(null, this.studyID, null, null, pager.getPageSize(), pager.getPage()).execute().body();
            list.addAll(br.data());
            pager.paginate(br.getMetadata());
        }
        return list;
    }

    public List<BrapiAlleleMatrix> getAlleleMatrix(List<BrapiMarkerProfile> markerprofiles) throws Exception {
        ArrayList<BrapiAlleleMatrix> list = new ArrayList<BrapiAlleleMatrix>();
        Pager pager = new Pager();
        List<String> ids = markerprofiles.stream().map(BrapiMarkerProfile::getMarkerProfileDbId).collect(Collectors.toList());
        while (pager.isPaging()) {
            BrapiBaseResource br = (BrapiBaseResource)this.service.getAlleleMatrix(ids, null, null, null, null, null, null, pager.getPageSize(), pager.getPage()).execute().body();
            list.add((BrapiAlleleMatrix)br.getResult());
            pager.paginate(br.getMetadata());
        }
        return list;
    }

    private URI getAlleleMatrixFile(List<BrapiMarkerProfile> markerProfiles, String format) throws Exception {
        List<String> ids = markerProfiles.stream().map(BrapiMarkerProfile::getMarkerProfileDbId).collect(Collectors.toList());
        BrapiBaseResource br = (BrapiBaseResource)this.service.getAlleleMatrix(ids, null, format, null, null, null, null, null, null).execute().body();
        Metadata md = br.getMetadata();
        List<String> files = md.getDatafiles();
        return new URI(files.get(0));
    }

    public URI getAlleleMatrixTSV(List<BrapiMarkerProfile> markerprofiles) throws Exception {
        return this.getAlleleMatrixFile(markerprofiles, "tsv");
    }

    public URI getAlleleMatrixFlapjack(List<BrapiMarkerProfile> markerProfiles) throws Exception {
        return this.getAlleleMatrixFile(markerProfiles, "flapjack");
    }

    public XmlBrapiProvider getBrapiProviders() throws Exception {
        URL url = new URL("https://ics.hutton.ac.uk/resources/brapi/brapi.zip");
        File dir = new File(FlapjackUtils.getCacheDir(), "brapi");
        dir.mkdirs();
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(url.openStream()));
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            int n;
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(dir, ze.getName())));
            BufferedInputStream in = new BufferedInputStream(zis);
            byte[] b = new byte[4096];
            while ((n = in.read(b)) != -1) {
                out.write(b, 0, n);
            }
            out.close();
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XmlBrapiProvider.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        File xml = new File(dir, "brapi.xml");
        return (XmlBrapiProvider)jaxbUnmarshaller.unmarshal(xml);
    }

    public boolean requiresAuthentication() throws Exception {
        Pager pager = new Pager();
        int responseCode = this.service.getStudies("genotype", pager.getPageSize(), pager.getPage()).execute().code();
        return responseCode == 401 || responseCode == 403;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getMethodID() {
        return this.methodID;
    }

    public void setMethodID(String methodID) {
        this.methodID = methodID;
    }

    public XmlResource getResource() {
        return this.resource;
    }

    public void setResource(XmlResource resource) {
        this.resource = resource;
    }

    public String getMapID() {
        return this.mapID;
    }

    public void setMapID(String mapIndex) {
        this.mapID = mapIndex;
    }

    public String getStudyID() {
        return this.studyID;
    }

    public void setStudyID(String studyID) {
        this.studyID = studyID;
    }

    private OkHttpClient initCertificate(OkHttpClient client, String certificate) throws Exception {
        if (certificate == null || certificate.isEmpty()) {
            return client;
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        InputStream caInput = new URL(this.resource.getCertificate()).openStream();
        Certificate ca = cf.generateCertificate(caInput);
        String keyStoreType = KeyStore.getDefaultType();
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(null, null);
        keyStore.setCertificateEntry("ca", ca);
        String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
        tmf.init(keyStore);
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, tmf.getTrustManagers(), null);
        client = client.newBuilder().sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)tmf.getTrustManagers()[0]).hostnameVerifier((s, sslSession) -> true).build();
        caInput.close();
        return client;
    }

    URLConnection addAuthTokenToConnection(URLConnection connection) {
        if (this.authToken != null && !this.authToken.isEmpty()) {
            connection.setRequestProperty("Authorization", "Bearer " + this.authToken);
        }
        return connection;
    }
}

