/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.colors;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.GTView;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.colors.ColorScheme;
import jhi.flapjack.gui.visualization.colors.ColorState;
import jhi.flapjack.gui.visualization.colors.HeterozygeousColorState;
import jhi.flapjack.gui.visualization.colors.HomozygousColorState;
import jhi.flapjack.gui.visualization.colors.SimpleColorState;
import scri.commons.gui.RB;

public class NucleotideColorScheme
extends ColorScheme {
    protected ArrayList<ColorState> states = new ArrayList();

    public NucleotideColorScheme() {
    }

    public NucleotideColorScheme(GTView view, int w, int h) {
        super(view);
        HashMap<String, Color> keys = new HashMap<String, Color>();
        keys.put("A", Prefs.visColorNucleotideA);
        keys.put("C", Prefs.visColorNucleotideC);
        keys.put("G", Prefs.visColorNucleotideG);
        keys.put("T", Prefs.visColorNucleotideT);
        this.buildStates(keys, w, h);
    }

    protected void buildStates(HashMap<String, Color> keys, int w, int h) {
        for (int i = 0; i < this.stateTable.size(); ++i) {
            Color c1;
            AlleleState state = this.stateTable.getAlleleState(i);
            ColorState c = null;
            if (state.isUnknown()) {
                c = new SimpleColorState(state, Prefs.visColorBackground, w, h);
            } else if (state.isHomozygous()) {
                c1 = keys.get(state.homzAllele());
                if (c1 == null) {
                    c1 = Prefs.visColorNucleotideOther;
                }
                c = new HomozygousColorState(state, c1, w, h);
            } else {
                c1 = keys.get(state.getState(0));
                Color c2 = keys.get(state.getState(1));
                if (c1 == null) {
                    c1 = Prefs.visColorNucleotideOther;
                }
                if (c2 == null) {
                    c2 = Prefs.visColorNucleotideOther;
                }
                c = new HeterozygeousColorState(state, Prefs.visColorNucleotideHZ, c1, c2, w, h);
            }
            this.states.add(c);
        }
    }

    @Override
    public BufferedImage getSelectedImage(int line, int marker, boolean underQTL) {
        int state = this.view.getState(line, marker);
        return this.states.get(state).getImage(underQTL);
    }

    @Override
    public BufferedImage getUnselectedImage(int line, int marker, boolean underQTL) {
        int state = this.view.getState(line, marker);
        return this.states.get(state).getUnselectedImage(underQTL);
    }

    @Override
    public Color getColor(int line, int marker) {
        int state = this.view.getState(line, marker);
        return this.states.get(state).getColor();
    }

    @Override
    public int getModel() {
        return 1;
    }

    public String toString() {
        return RB.getString((String)"gui.Actions.vizColorNucleotide");
    }

    @Override
    public String getDescription() {
        return RB.getString((String)"gui.visualization.colors.NucleotideColorScheme");
    }

    @Override
    public ArrayList<ColorScheme.ColorSummary> getColorSummaries() {
        ArrayList<ColorScheme.ColorSummary> colors = new ArrayList<ColorScheme.ColorSummary>();
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorNucleotideA, RB.getString((String)"gui.visualization.colors.NucleotideColorScheme.a")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorNucleotideC, RB.getString((String)"gui.visualization.colors.NucleotideColorScheme.c")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorNucleotideG, RB.getString((String)"gui.visualization.colors.NucleotideColorScheme.g")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorNucleotideT, RB.getString((String)"gui.visualization.colors.NucleotideColorScheme.t")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorNucleotideHZ, RB.getString((String)"gui.visualization.colors.NucleotideColorScheme.hz")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorNucleotideOther, RB.getString((String)"gui.visualization.colors.NucleotideColorScheme.other")));
        return colors;
    }

    @Override
    public void setColorSummaries(ArrayList<ColorScheme.ColorSummary> colors) {
        Prefs.visColorNucleotideA = colors.get((int)0).color;
        Prefs.visColorNucleotideC = colors.get((int)1).color;
        Prefs.visColorNucleotideG = colors.get((int)2).color;
        Prefs.visColorNucleotideT = colors.get((int)3).color;
        Prefs.visColorNucleotideHZ = colors.get((int)4).color;
        Prefs.visColorNucleotideOther = colors.get((int)5).color;
    }
}

