/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.analysis;

import java.awt.Color;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import jhi.flapjack.analysis.AnalysisSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.StateTable;
import scri.commons.gui.RB;

class DataSummaryPanelNB
extends JPanel
implements AdjustmentListener {
    private NumberFormat nf = NumberFormat.getInstance();
    private DecimalFormat d = new DecimalFormat("0.0");
    private JScrollPane sp1;
    private JScrollPane sp2;
    private JTable sumTable;
    private JLabel tableLabel1;
    private JLabel tableLabel2;
    private JPanel tablePanel;
    private JLabel viewLabel;
    private JTable viewTable;

    public DataSummaryPanelNB(GTViewSet viewSet, AnalysisSet as, ArrayList<long[]> results, long alleleCount) {
        this.initComponents();
        this.setBackground((Color)UIManager.get("fjDialogBG"));
        this.tablePanel.setBackground((Color)UIManager.get("fjDialogBG"));
        String name = viewSet.getName();
        this.viewLabel.setText(RB.format((String)"gui.dialog.analysis.NBAlleleStatisticsPanel.viewLabel", (Object[])new Object[]{name, alleleCount}));
        this.tablePanel.setBorder(BorderFactory.createTitledBorder(RB.getString((String)"gui.dialog.analysis.NBAlleleStatisticsPanel.tablePanel.title")));
        RB.setText((JLabel)this.tableLabel1, (String)"gui.dialog.analysis.NBAlleleStatisticsPanel.tableLabel1");
        RB.setText((JLabel)this.tableLabel2, (String)"gui.dialog.analysis.NBAlleleStatisticsPanel.tableLabel2");
        this.createSumTable(viewSet.getDataSet().getStateTable(), results);
        this.createViewTable(viewSet.getDataSet().getStateTable(), as, results);
        this.sp1.getVerticalScrollBar().addAdjustmentListener(this);
        this.sp2.getVerticalScrollBar().addAdjustmentListener(this);
    }

    private void createSumTable(StateTable stateTable, ArrayList<long[]> results) {
        int i;
        Object[][] r = new Object[stateTable.size()][3];
        for (int i2 = 0; i2 < r.length; ++i2) {
            r[i2][0] = stateTable.getAlleleState(i2);
        }
        long[] totals = new long[r.length];
        long alleleTotal = 0L;
        for (i = 0; i < r.length; ++i) {
            for (long[] data : results) {
                int n = i;
                totals[n] = totals[n] + data[i];
            }
            alleleTotal += totals[i];
        }
        for (i = 0; i < r.length; ++i) {
            float prct = (float)totals[i] / (float)alleleTotal * 100.0f;
            r[i][1] = this.nf.format(totals[i]);
            r[i][2] = this.d.format(prct);
        }
        Object[] names = new String[]{RB.getString((String)"gui.dialog.analysis.NBAlleleStatisticsPanel.sumTable.state"), RB.getString((String)"gui.dialog.analysis.NBAlleleStatisticsPanel.sumTable.count"), "%"};
        this.sumTable.setModel(new DefaultTableModel(r, names){

            @Override
            public boolean isCellEditable(int rowIndex, int mColIndex) {
                return false;
            }
        });
        this.sumTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.sumTable.getColumnModel().getColumn(1).setPreferredWidth(70);
        this.sumTable.getColumnModel().getColumn(2).setPreferredWidth(35);
        DefaultTableCellRenderer cr = new DefaultTableCellRenderer();
        cr.setHorizontalAlignment(4);
        this.sumTable.setDefaultRenderer(Object.class, cr);
    }

    private void createViewTable(StateTable stateTable, AnalysisSet as, ArrayList<long[]> results) {
        int viewCount = as.viewCount();
        Object[] names = new String[viewCount * 2];
        int i = 0;
        int col = 0;
        while (i < viewCount) {
            names[col] = as.getGTView(i).getChromosomeMap().getName();
            names[col + 1] = "%";
            ++i;
            col += 2;
        }
        Object[][] r = new Object[stateTable.size()][viewCount * 2];
        int view = 0;
        int col2 = 0;
        while (view < viewCount) {
            long[] data = results.get(view);
            for (int i2 = 0; i2 < r.length; ++i2) {
                long value = data[i2];
                float prct = (float)data[i2] / (float)data[data.length - 1] * 100.0f;
                r[i2][col2] = this.nf.format(value);
                r[i2][col2 + 1] = this.d.format(prct);
            }
            ++view;
            col2 += 2;
        }
        this.viewTable.setModel(new DefaultTableModel(r, names){

            @Override
            public boolean isCellEditable(int rowIndex, int mColIndex) {
                return false;
            }
        });
        for (int i3 = 0; i3 < viewCount * 2; ++i3) {
            if (i3 % 2 == 0) {
                this.viewTable.getColumnModel().getColumn(i3).setPreferredWidth(70);
                continue;
            }
            this.viewTable.getColumnModel().getColumn(i3).setPreferredWidth(35);
        }
        DefaultTableCellRenderer cr = new DefaultTableCellRenderer();
        cr.setHorizontalAlignment(4);
        this.viewTable.setDefaultRenderer(Object.class, cr);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.sp1.getVerticalScrollBar()) {
            int value = this.sp1.getVerticalScrollBar().getValue();
            this.sp2.getVerticalScrollBar().setValue(value);
        } else {
            int value = this.sp2.getVerticalScrollBar().getValue();
            this.sp1.getVerticalScrollBar().setValue(value);
        }
    }

    private void initComponents() {
        this.viewLabel = new JLabel();
        this.tablePanel = new JPanel();
        this.sp2 = new JScrollPane();
        this.viewTable = new JTable();
        this.tableLabel2 = new JLabel();
        this.sp1 = new JScrollPane();
        this.sumTable = new JTable();
        this.tableLabel1 = new JLabel();
        this.viewLabel.setText("Summary for view: <viewname>");
        this.tablePanel.setBorder(BorderFactory.createTitledBorder("Allele summary:"));
        this.sp2.setHorizontalScrollBarPolicy(32);
        this.viewTable.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.viewTable.setAutoResizeMode(0);
        this.sp2.setViewportView(this.viewTable);
        this.tableLabel2.setLabelFor(this.viewTable);
        this.tableLabel2.setText("Breakdown by chromosome:");
        this.sp1.setHorizontalScrollBarPolicy(32);
        this.sumTable.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.sumTable.setAutoResizeMode(4);
        this.sp1.setViewportView(this.sumTable);
        this.tableLabel1.setLabelFor(this.sumTable);
        this.tableLabel1.setText("Totals:");
        GroupLayout tablePanelLayout = new GroupLayout(this.tablePanel);
        this.tablePanel.setLayout(tablePanelLayout);
        tablePanelLayout.setHorizontalGroup(tablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tablePanelLayout.createSequentialGroup().addContainerGap().addGroup(tablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tableLabel1).addComponent(this.sp1, -2, 180, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tableLabel2).addComponent(this.sp2, -1, 372, Short.MAX_VALUE)).addContainerGap()));
        tablePanelLayout.setVerticalGroup(tablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tablePanelLayout.createSequentialGroup().addContainerGap().addGroup(tablePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tableLabel1).addComponent(this.tableLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sp2, -1, 207, Short.MAX_VALUE).addComponent(this.sp1, -1, 207, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.viewLabel).addComponent(this.tablePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.viewLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tablePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }
}

