/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import jhi.flapjack.data.GraphData;
import jhi.flapjack.data.Marker;
import jhi.flapjack.data.QTL;
import jhi.flapjack.data.XMLRoot;

public class ChromosomeMap
extends XMLRoot
implements Iterable<Marker>,
Comparable<ChromosomeMap> {
    private String name;
    private double length;
    private boolean isSpecialChromosome;
    private ArrayList<Marker> markers = new ArrayList();
    private ArrayList<QTL> qtls = new ArrayList();
    private ArrayList<GraphData> graphs = new ArrayList();

    public ChromosomeMap() {
    }

    public ChromosomeMap(String name) {
        this.name = new String(name);
    }

    void validate() throws NullPointerException {
        if (this.name == null) {
            throw new NullPointerException();
        }
        for (Marker marker : this.markers) {
            marker.validate();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public ArrayList<Marker> getMarkers() {
        return this.markers;
    }

    public void setMarkers(ArrayList<Marker> markers) {
        this.markers = markers;
    }

    public ArrayList<QTL> getQtls() {
        return this.qtls;
    }

    public void setQtls(ArrayList<QTL> qtls) {
        this.qtls = qtls;
    }

    public boolean isSpecialChromosome() {
        return this.isSpecialChromosome;
    }

    public void setSpecialChromosome(boolean isSpecialChromosome) {
        this.isSpecialChromosome = isSpecialChromosome;
    }

    public ArrayList<GraphData> getGraphs() {
        return this.graphs;
    }

    public void setGraphs(ArrayList<GraphData> graphs) {
        this.graphs = graphs;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Iterator<Marker> iterator() {
        return this.markers.iterator();
    }

    @Override
    public int compareTo(ChromosomeMap other) {
        if (this.nameIsNumber() && other.nameIsNumber()) {
            return Double.compare(Double.parseDouble(this.name), Double.parseDouble(other.name));
        }
        if (this.nameIsNumber() && !other.nameIsNumber()) {
            return -1;
        }
        if (!this.nameIsNumber() && other.nameIsNumber()) {
            return 1;
        }
        return this.name.compareTo(other.name);
    }

    private boolean nameIsNumber() {
        try {
            Double.parseDouble(this.name);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Marker getMarkerByIndex(int index) throws ArrayIndexOutOfBoundsException {
        return this.markers.get(index);
    }

    public int countLoci() {
        return this.markers.size();
    }

    boolean containsMarker(String markerName) {
        return this.getMarkerIndex(markerName) != -1;
    }

    public void addMarker(Marker marker) {
        this.markers.add(marker);
    }

    public void sort() {
        this.markers.trimToSize();
        Collections.sort(this.markers);
        if (this.length == 0.0 && this.markers.size() > 0) {
            this.length = this.markers.get(this.markers.size() - 1).getPosition();
        }
        System.out.println("Map " + this.name + " has length " + this.length);
    }

    public int getMarkerIndex(String markerName) {
        for (int i = 0; i < this.markers.size(); ++i) {
            if (!this.markers.get(i).getName().equals(markerName)) continue;
            return i;
        }
        return -1;
    }

    public static class Wrapper {
        public ChromosomeMap map;
        public short index;

        public Wrapper(ChromosomeMap map, int index) {
            this.map = map;
            this.index = (short)index;
        }
    }
}

