/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.binning;

import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import jhi.flapjack.data.StateTable;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.colors.BinnedColorScheme;
import jhi.flapjack.io.binning.AutoBinner;
import jhi.flapjack.io.binning.IBinner;
import jhi.flapjack.io.binning.SplitBinner;
import jhi.flapjack.io.binning.StandardBinner;

public class CreateImage {
    private IBinner binner;
    private String imageFile;

    public static void main(String[] args) throws Exception {
        NumberFormat nf = NumberFormat.getInstance();
        String imageFile = args[0];
        CreateImage imageCreator = new CreateImage(imageFile);
        String method = args[1].toUpperCase();
        if (method.equals("STANDARD")) {
            int numBins = Integer.parseInt(args[2]);
            imageCreator.createStandardImage(numBins);
        } else if (method.equals("SPLIT")) {
            int lBinCount = Integer.parseInt(args[2]);
            float split = nf.parse(args[3]).floatValue();
            int rBinCount = Integer.parseInt(args[4]);
            imageCreator.createSplitImage(lBinCount, split, rBinCount);
        } else if (method.equals("AUTO")) {
            int numBins = Integer.parseInt(args[2]);
            String histFile = args[3];
            imageCreator.createAutoImage(numBins, histFile);
        }
    }

    public CreateImage(String imageFile) {
        this.imageFile = imageFile;
    }

    public void createStandardImage(int numBins) throws Exception {
        this.binner = new StandardBinner(numBins);
        this.createImage();
    }

    public void createAutoImage(int numBins, String histogramFile) throws Exception {
        this.binner = new AutoBinner(numBins, histogramFile);
        this.createImage();
    }

    public void createSplitImage(int lBinCount, float split, int rBinCount) throws Exception {
        this.binner = new SplitBinner(lBinCount, split, rBinCount);
        this.createImage();
    }

    private void createImage() throws Exception {
        int bin;
        ArrayList<float[]> bins = this.binner.getBinSummary();
        float totalSize = bins.get(bins.size() - 1)[1];
        StateTable stateTable = new StateTable(0);
        for (int i = 0; i < bins.size(); ++i) {
            stateTable.getStateCode("" + i, true, "", true, "/");
        }
        Prefs.setColorDefaults();
        BinnedColorScheme colors = new BinnedColorScheme(stateTable, 5, 5);
        PrintWriter writer = new PrintWriter(new FileWriter(new File(this.imageFile)));
        NumberFormat nf = NumberFormat.getNumberInstance();
        for (bin = 0; bin < bins.size(); ++bin) {
            float[] binArr = bins.get(bin);
            float percent = (binArr[1] - binArr[0]) / totalSize * 100.0f;
            String out = bin < bins.size() - 1 ? nf.format(percent) + ", " : "" + nf.format(percent);
            writer.print(out);
        }
        writer.println();
        for (bin = 0; bin < bins.size(); ++bin) {
            Color color = colors.getColor(bin);
            String hex = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
            if (bin < bins.size() - 1) {
                writer.print(hex + ", ");
                continue;
            }
            writer.println(hex);
        }
        writer.close();
    }
}

