/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import jhi.flapjack.gui.visualization.MapCanvas;

class MapCanvasAAThread
extends Thread {
    private static MapCanvasAAThread previousThread;
    static boolean bufferAvailable;
    private Boolean killMe = false;
    private MapCanvas canvas;
    private int xS;
    private int xE;

    public MapCanvasAAThread(MapCanvas canvas, int xS, int xE) {
        this.canvas = canvas;
        this.xS = xS;
        this.xE = xE;
        bufferAvailable = false;
        if (previousThread != null) {
            MapCanvasAAThread.previousThread.killMe = true;
            previousThread.interrupt();
        }
        previousThread = this;
        this.start();
    }

    @Override
    public void run() {
        this.setPriority(1);
        try {
            Thread.sleep(333L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.killMe.booleanValue()) {
            return;
        }
        Graphics2D g = this.canvas.getAntiAliasedBufferGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.canvas.getBackground());
        g.fillRect(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
        this.canvas.render(g, this.xS, this.xE);
        g.dispose();
        if (!this.killMe.booleanValue()) {
            bufferAvailable = true;
            this.canvas.repaint();
        }
    }

    static {
        bufferAvailable = false;
    }
}

