/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.table;

import java.awt.Color;
import java.awt.Component;
import java.text.NumberFormat;
import java.util.Comparator;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.gui.table.LineDataTable;
import jhi.flapjack.gui.table.LineDataTableModel;

public class CellData {
    private LineInfo line;
    private Object data;

    public CellData(LineInfo line, Object data) {
        this.line = line;
        this.data = data;
    }

    LineInfo getLineInfo() {
        return this.line;
    }

    public Object getData() {
        return this.data;
    }

    public String toString() {
        return this.data.toString();
    }

    private static Color calcBackground(JTable table, int row, boolean isSelected) {
        int modelRow;
        LineDataTableModel model = (LineDataTableModel)table.getModel();
        Object obj = model.getObjectAt(modelRow = table.convertRowIndexToModel(row), 0);
        if (obj instanceof LineInfo && ((LineInfo)obj).getResults().isSortToTop()) {
            return isSelected ? DefaultRenderer.bgNoSortSel : DefaultRenderer.bgNoSort;
        }
        return isSelected ? DefaultRenderer.bgCol1 : DefaultRenderer.bgCol2;
    }

    static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            this.setBackground(CellData.calcBackground(table, row, isSelected));
            return this;
        }
    }

    static class DefaultRenderer
    extends DefaultTableCellRenderer {
        private static BooleanRenderer bRenderer = new BooleanRenderer();
        protected final NumberFormat nf = NumberFormat.getInstance();
        private boolean colorCells = true;
        static Color bgCol1 = UIManager.getColor("Table.selectionBackground");
        static Color bgCol2 = UIManager.getColor("Table.background");
        static Color bgNoSort = new Color(206, 221, 235);
        static Color bgNoSortSel = bgCol1.darker();

        DefaultRenderer() {
        }

        void setColorCells(boolean colorCells) {
            this.colorCells = colorCells;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
            if (o instanceof Boolean) {
                return bRenderer.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
            }
            if (((CellData)o).getData() instanceof Boolean) {
                return bRenderer.getTableCellRendererComponent(table, ((CellData)o).getData(), isSelected, hasFocus, row, column);
            }
            Object value = ((CellData)o).getData();
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Number) {
                this.setText(this.getNumberString((Number)value));
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
            int iRow = table.getRowSorter().convertRowIndexToModel(row);
            LineDataTableModel model = ((LineDataTable)table).getLineDataTableModel();
            Color bg = model.getDisplayColor(iRow, column);
            if (this.colorCells && bg != null) {
                this.setBackground(isSelected ? bg.darker() : bg);
            } else {
                this.setBackground(CellData.calcBackground(table, row, isSelected));
            }
            return this;
        }

        private String getNumberString(Number value) {
            if (value instanceof Double && (Double.isNaN((Double)value) || Double.isInfinite((Double)value))) {
                return value.toString();
            }
            if (value instanceof Float && (Float.isNaN(((Float)value).floatValue()) || Float.isInfinite(((Float)value).floatValue()))) {
                return value.toString();
            }
            return this.nf.format(value);
        }
    }

    static class CellDataComparator
    implements Comparator<CellData> {
        private TableRowSorter<LineDataTableModel> sorter;

        CellDataComparator(TableRowSorter<LineDataTableModel> sorter) {
            this.sorter = sorter;
        }

        @Override
        public int compare(CellData v1, CellData v2) {
            boolean asc;
            boolean bl = asc = this.sorter.getSortKeys().get(0).getSortOrder() == SortOrder.ASCENDING;
            if (v1.line != null && v2.line != null) {
                boolean v1SortToTop = v1.line.getResults().isSortToTop();
                boolean v2SortToTop = v2.line.getResults().isSortToTop();
                if (v1SortToTop && !v2SortToTop) {
                    return asc ? -1 : 1;
                }
                if (v2SortToTop && !v1SortToTop) {
                    return asc ? 1 : -1;
                }
                if (v1SortToTop && v2SortToTop) {
                    return 0;
                }
            }
            return this.compareTo(v1, v2);
        }

        private int compareTo(CellData v1, CellData v2) {
            if (v1.data instanceof Double && v2.data instanceof Double) {
                return ((Double)v1.data).compareTo((Double)v2.data);
            }
            if (v1.data instanceof Integer && v2.data instanceof Integer) {
                return ((Integer)v1.data).compareTo((Integer)v2.data);
            }
            if (v1.data instanceof Boolean && v2.data instanceof Boolean) {
                return ((Boolean)v1.data).compareTo((Boolean)v2.data);
            }
            if (v1.data instanceof Float && v2.data instanceof Float) {
                return ((Float)v1.data).compareTo((Float)v2.data);
            }
            if (v1.data != null && v2.data != null) {
                return v1.data.toString().compareTo(v2.data.toString());
            }
            if (v1.data != null) {
                return 1;
            }
            if (v2.data != null) {
                return -1;
            }
            return 0;
        }
    }
}

