/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.importer;

import java.awt.Color;
import java.awt.Frame;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import jhi.brapi.api.genomemaps.BrapiGenomeMap;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.dialog.importer.BrapiImportDialog;
import jhi.flapjack.gui.dialog.importer.IBrapiWizard;
import jhi.flapjack.io.brapi.BrapiClient;
import scri.commons.gui.ITrackableJob;
import scri.commons.gui.ProgressDialog;
import scri.commons.gui.RB;
import scri.commons.gui.SimpleJob;

class BrapiMapsPanelNB
extends JPanel
implements IBrapiWizard {
    private BrapiClient client;
    private List<BrapiGenomeMap> maps;
    private BrapiImportDialog dialog;
    private DefaultComboBoxModel<String> mapModel;
    private JCheckBox checkSkipMap;
    private JLabel detailsLabel;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JComboBox<String> mapsCombo;
    private JLabel mapsLabel;
    private JTextArea text;

    public BrapiMapsPanelNB(BrapiClient client, BrapiImportDialog dialog) {
        this.client = client;
        this.dialog = dialog;
        this.initComponents();
        this.checkSkipMap.setSelected(Prefs.guiBrapiSkipMap);
        this.checkSkipMap.addActionListener(e -> {
            Prefs.guiBrapiSkipMap = this.checkSkipMap.isSelected();
            this.displayMap();
        });
        this.mapsCombo.addActionListener(e -> this.displayMap());
    }

    private void displayMap() {
        int index = this.mapsCombo.getSelectedIndex();
        if (index >= 0) {
            BrapiGenomeMap map = this.maps.get(index);
            this.client.setMapID("" + map.getMapDbId());
            String str = "Species: " + map.getSpecies() + "\nType: " + map.getType() + "\nUnit: " + map.getUnit() + "\nDate: " + map.getPublishedDate() + "\nMarkers: " + map.getMarkerCount() + "\nChromosomes: " + map.getLinkageGroupCount();
            this.text.setText(str);
        } else {
            this.text.setText("");
        }
        this.dialog.enableNext(index >= 0 || this.checkSkipMap.isSelected());
    }

    private void refreshMaps() {
        ProgressDialog pd = new ProgressDialog((ITrackableJob)new DataDownloader(), RB.getString((String)"gui.dialog.importer.BrapiMapsPanelNB.title"), RB.getString((String)"gui.dialog.importer.BrapiMapsPanelNB.message"), (Frame)Flapjack.winMain);
        if (pd.failed("gui.error")) {
            return;
        }
        this.mapModel = new DefaultComboBoxModel();
        for (BrapiGenomeMap map : this.maps) {
            this.mapModel.addElement(map.getMapDbId() + " - " + map.getName());
        }
        this.mapsCombo.setModel(this.mapModel);
        this.displayMap();
    }

    @Override
    public void onShow() {
        this.dialog.enableBack(true);
        if (this.mapModel == null || this.mapModel.getSize() == 0) {
            this.refreshMaps();
        }
    }

    @Override
    public void onNext() {
        this.dialog.wizardCompleted();
    }

    @Override
    public void onBack() {
        this.dialog.setScreen(this.dialog.getStudiesPanel());
        this.dialog.getBBack().requestFocusInWindow();
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public String getCardName() {
        return "maps";
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.mapsLabel = new JLabel();
        this.mapsCombo = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.text = new JTextArea();
        this.detailsLabel = new JLabel();
        this.checkSkipMap = new JCheckBox();
        this.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Map selection:"));
        this.mapsLabel.setLabelFor(this.mapsCombo);
        this.mapsLabel.setText("Available maps:");
        this.text.setEditable(false);
        this.text.setColumns(20);
        this.text.setRows(5);
        this.jScrollPane1.setViewportView(this.text);
        this.detailsLabel.setText("Details:");
        this.checkSkipMap.setText("Skip using a map (not recommended) - a 'dummy' chromosome will hold markers instead");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.mapsLabel).addGap(11, 11, 11).addComponent(this.mapsCombo, 0, -1, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkSkipMap).addComponent(this.detailsLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mapsLabel).addComponent(this.mapsCombo, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.detailsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 127, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.checkSkipMap).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private class DataDownloader
    extends SimpleJob {
        private DataDownloader() {
        }

        public void runJob(int jobID) throws Exception {
            BrapiMapsPanelNB.this.maps = BrapiMapsPanelNB.this.client.getMaps();
        }
    }
}

