/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import jhi.flapjack.analysis.AnalysisSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.MarkerInfo;
import scri.commons.gui.SimpleJob;

public class FilterMissingMarkers
extends SimpleJob {
    private GTViewSet viewSet;
    private boolean[] selectedChromosomes;
    private int cutoff;
    private int count;

    public FilterMissingMarkers(GTViewSet viewSet, boolean[] selectedChromosomes, int cutoff) {
        this.viewSet = viewSet;
        this.selectedChromosomes = selectedChromosomes;
        this.cutoff = cutoff;
    }

    public int getCount() {
        return this.count;
    }

    public void runJob(int index) throws Exception {
        AnalysisSet as = new AnalysisSet(this.viewSet).withViews(this.selectedChromosomes).withSelectedLines().withSelectedMarkers();
        for (int i = 0; i < as.viewCount(); ++i) {
            this.maximum += as.markerCount(i);
        }
        for (int view = 0; view < as.viewCount(); ++view) {
            boolean isSpecialChromosome = as.getGTView(view).getChromosomeMap().isSpecialChromosome();
            for (int i = as.markerCount(view) - 1; i >= 0 && this.okToRun; --i) {
                int allelesCount = 0;
                int missingCount = 0;
                for (int j = 0; j < as.lineCount() && this.okToRun; ++j) {
                    if (as.getState(view, j, i) == 0) {
                        ++missingCount;
                    }
                    ++allelesCount;
                }
                if ((float)missingCount / (float)allelesCount * 100.0f >= (float)this.cutoff) {
                    MarkerInfo mi = as.getMarker(view, i);
                    as.getGTView(view).hideMarker(mi);
                    if (!isSpecialChromosome) {
                        ++this.count;
                    }
                }
                ++this.progress;
            }
        }
    }
}

