/*
 * Decompiled with CFR 0.152.
 */
package scri.commons.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import scri.commons.gui.ITrackableJob;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;
import scri.commons.gui.matisse.DialogPanel;

public class ProgressDialog
extends JDialog
implements Runnable,
ActionListener {
    public static final int JOB_COMPLETED = 0;
    public static final int JOB_CANCELLED = 1;
    public static final int JOB_FAILED = 2;
    private static DecimalFormat df = new DecimalFormat("0.00");
    DateFormat tf = new SimpleDateFormat("HH:mm:ss");
    private ITrackableJob job;
    private int jobStatus = 0;
    private Timer timer;
    private long startTime;
    private Exception exception = null;
    private JButton bCancel;
    private DialogPanel buttonPanel;
    private JLabel etaLabel;
    private JLabel mainLabel;
    private JLabel msgLabel;
    private JProgressBar pBar;
    private JPanel panel;

    public ProgressDialog(ITrackableJob job, String title, String label, Frame owner) {
        super(owner, title, true);
        this.job = job;
        this.initComponents();
        this.mainLabel.setText(label);
        this.msgLabel.setText("  ");
        this.etaLabel.setText(" ");
        this.pBar.setString("0.00%");
        this.pBar.setMaximum(job.getMaximum());
        this.pBar.setIndeterminate(job.isIndeterminate());
        this.bCancel.addActionListener(e -> this.cancelJob());
        new Thread(this).start();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProgressDialog.this.cancelJob();
            }
        });
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.getContentPane().setBackground(Color.white);
        this.pack();
        this.setLocationRelativeTo(owner);
        if (this.job != null) {
            this.setVisible(true);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(500, super.getPreferredSize().height);
    }

    void setMessage(String message) {
        this.msgLabel.setText(message);
    }

    public int getResult() {
        return this.jobStatus;
    }

    public Exception getException() {
        return this.exception;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.job == null) {
            this.timer.stop();
            this.setVisible(false);
            return;
        }
        try {
            this.pBar.setIndeterminate(this.job.isIndeterminate());
            this.pBar.setStringPainted(!this.job.isIndeterminate());
            int val = this.job.getValue();
            int max = this.job.getMaximum();
            this.pBar.setMaximum(max);
            this.pBar.setValue(val);
            if (val == 0) {
                this.startTime = System.currentTimeMillis();
                this.etaLabel.setText("00:00:00");
            } else {
                long time = System.currentTimeMillis() - this.startTime;
                float timePerUnit = (float)time / (float)val;
                int unitsRemaining = max - val;
                long timeRemaining = (long)((float)unitsRemaining * timePerUnit);
                Date date = new Date(timeRemaining);
                this.etaLabel.setText(this.tf.format(date));
            }
            String message = this.job.getMessage();
            if (message != null) {
                this.msgLabel.setText(message);
            }
            if (max == 0) {
                this.pBar.setString(df.format(0L) + "%");
            } else {
                float value = (float)val / (float)max * 100.0f;
                this.pBar.setString(df.format(value) + "%");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cancelJob() {
        this.job.cancelJob();
        this.jobStatus = 1;
    }

    public boolean failed(String rbString) {
        if (this.jobStatus == 0) {
            return false;
        }
        if (this.jobStatus == 2) {
            String message = this.exception.getMessage();
            if (message == null) {
                message = this.exception.toString();
            }
            TaskDialog.errorWithLog(RB.format(rbString, message));
        }
        return true;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("ProgressDialog-ITrackableJob");
        this.startTime = System.currentTimeMillis();
        this.tf.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.timer = new Timer(100, this);
        this.timer.start();
        try {
            for (int i = 0; i < this.job.getJobCount() && this.jobStatus == 0; ++i) {
                this.job.runJob(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exception = e;
            this.jobStatus = 2;
        }
        this.job = null;
    }

    private void initComponents() {
        this.panel = new JPanel();
        this.mainLabel = new JLabel();
        this.pBar = new JProgressBar();
        this.msgLabel = new JLabel();
        this.etaLabel = new JLabel();
        this.buttonPanel = new DialogPanel();
        this.bCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.panel.setBackground(new Color(255, 255, 255));
        this.mainLabel.setText("mainLabel");
        this.msgLabel.setText("msgLabel");
        this.etaLabel.setText("etaLabel");
        GroupLayout panelLayout = new GroupLayout(this.panel);
        this.panel.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLayout.createSequentialGroup().addContainerGap().addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pBar, -2, 0, Short.MAX_VALUE).addGroup(panelLayout.createSequentialGroup().addComponent(this.mainLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(panelLayout.createSequentialGroup().addComponent(this.msgLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 55, Short.MAX_VALUE).addComponent(this.etaLabel))).addContainerGap()));
        panelLayout.setVerticalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLayout.createSequentialGroup().addContainerGap().addComponent(this.mainLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.msgLabel).addComponent(this.etaLabel)).addContainerGap()));
        this.getContentPane().add((Component)this.panel, "Center");
        this.bCancel.setText("Cancel");
        this.buttonPanel.add(this.bCancel);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }
}

