/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv;

import com.fasterxml.jackson.core.JsonEncoding;

public enum CsvEncoding {
    UTF8("UTF-8", false),
    UTF16_BE("UTF-16BE", true),
    UTF16_LE("UTF-16LE", false),
    UTF32_BE("UTF-32BE", true),
    UTF32_LE("UTF-32LE", false),
    LATIN1("ISO-8859-1", false);

    protected final String _javaName;
    protected final boolean _bigEndian;

    private CsvEncoding(String javaName, boolean bigEndian) {
        this._javaName = javaName;
        this._bigEndian = bigEndian;
    }

    public static CsvEncoding from(JsonEncoding enc) {
        switch (enc) {
            case UTF8: {
                return UTF8;
            }
            case UTF16_BE: {
                return UTF16_BE;
            }
            case UTF16_LE: {
                return UTF16_LE;
            }
            case UTF32_BE: {
                return UTF32_BE;
            }
            case UTF32_LE: {
                return UTF32_LE;
            }
        }
        throw new IllegalStateException();
    }

    public String getJavaName() {
        return this._javaName;
    }

    public boolean isBigEndian() {
        return this._bigEndian;
    }
}

