/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.util;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.service.Service;
import org.restlet.util.WrapperList;

public final class ServiceList
extends WrapperList<Service> {
    private volatile Context context;

    public ServiceList(Context context) {
        super(new CopyOnWriteArrayList());
        this.context = context;
    }

    @Override
    public void add(int index, Service service) {
        service.setContext(this.getContext());
        super.add(index, service);
    }

    @Override
    public boolean add(Service service) {
        service.setContext(this.getContext());
        return super.add(service);
    }

    @Override
    public boolean addAll(Collection<? extends Service> services) {
        if (services != null) {
            for (Service service : services) {
                service.setContext(this.getContext());
            }
        }
        return super.addAll(services);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Service> services) {
        if (services != null) {
            for (Service service : services) {
                service.setContext(this.getContext());
            }
        }
        return super.addAll(index, services);
    }

    public <T extends Service> T get(Class<T> clazz) {
        for (Service service : this) {
            if (!clazz.isAssignableFrom(service.getClass())) continue;
            return (T)service;
        }
        return null;
    }

    public Context getContext() {
        return this.context;
    }

    public synchronized void set(List<Service> services) {
        this.clear();
        if (services != null) {
            this.addAll((Collection<? extends Service>)services);
        }
    }

    public synchronized void set(Service newService) {
        CopyOnWriteArrayList<Service> services = new CopyOnWriteArrayList<Service>();
        boolean replaced = false;
        for (int i = 0; i < this.size(); ++i) {
            Service service = (Service)this.get(i);
            if (service == null) continue;
            if (service.getClass().isAssignableFrom(newService.getClass())) {
                try {
                    service.stop();
                }
                catch (Exception e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Unable to stop service replaced", e);
                }
                services.add(newService);
                replaced = true;
                continue;
            }
            services.add(service);
        }
        if (!replaced) {
            services.add(newService);
        }
        this.set(services);
    }

    public void setContext(Context context) {
        this.context = context;
        for (Service service : this) {
            service.setContext(context);
        }
    }

    public void start() throws Exception {
        for (Service service : this) {
            service.start();
        }
    }

    public void stop() throws Exception {
        for (Service service : this) {
            service.stop();
        }
    }
}

