# AIM: Test some IO features betweent Python/Galaxy and R
# 
# Author: Christian Hundsrucker
###############################################################################
#options(echo=FALSE) #non-interactive -> galaxy
#options(echo=TRUE)
#I/O
#args: filename input
cargs <- commandArgs(trailingOnly = TRUE)
args.no<-length(cargs)-1 #last argument is output-file
outputfile<-cargs[args.no+1]

#functions
mapKV<-function(keyValue){
	if (length(keyValue)>2){
		stop("Wrong arguments used!")
	}
	if (length(keyValue)==2){
		value<-keyValue[2]
		names(value)<-keyValue[1]
	}else {
		value<-keyValue[1]
		names(value)<-""
	}
	return(value)
}

KVargs<-strsplit(cargs[1:args.no],"([ \t])*=([ \t])*",fixed = FALSE, perl = FALSE, useBytes = FALSE)
keyValues<-unlist(lapply(KVargs,mapKV))

output<-paste(names(keyValues),keyValues,sep=" -- ")
output<-paste(output,"\n","current dir: ",getwd(),"\n",sep="")
capture.output(print(output),file=outputfile,append=FALSE)
