#include <iostream>
#include <string>
#include <vector>

#include "args.h"
#include "Fasta.h"
#include "FastaRecord.h"
#include "Sam.h"
#include "SnipDriver.h"

using namespace std;

void print_fasta(const Fasta &f) {
	for(const auto &record: f.records) {
		cout << record.gene_id() << endl;
		cout << record.gene() << endl;
	}
}

void print_sam(const Sam &s) {
	for(const auto &alignment: s.alignments) {
		cout << alignment.alignment() << endl;
	}
}

int main(int argc, const char *argv[]) {
	cmd_args arg;
	arg = parse_command_line(argc, argv);		

	Fasta f(arg.amr_fp);
	f.read_fasta(arg.amr_fp);	

	Sam s(arg.sam_fp);
	if(arg.samse) {
		s.read_se_sam(arg.sam_fp, arg.best);
	}
	else {
		s.read_pe_sam(arg.sam_fp, arg.best);
	}

	run(f.records, s.alignments, arg);
	write_snips(f.records, arg.out_fp);


	return 0;
}
