#ifndef FASTA_RECORD_H
#define FASTA_RECORD_H

#include <string>
#include <vector>
#include <map>

class FastaRecord {
public:
	FastaRecord(std::string gene_id, std::string gene);
	
	inline std::string gene_id() const	{ return _gene_id; };
	inline std::string gene() const		{ return _gene;	};

	static int find_gene(const std::vector<FastaRecord> &records,
			     const std::string &gene_id,
			     std::string seq = "");
	static void sort_by_gene_id(std::vector<FastaRecord> &records);

	std::map<std::string, int> snip_database;
private:
	std::string _gene_id;
	std::string _gene;
};


#endif //FASTA_RECORD_H
