#ifndef SAM_H
#define SAM_H

#include <string>
#include <vector>

#include "args.h"
#include "Alignments.h"

/**
 * Class for dealing with sam files
 */

class Sam {
public:
	/**
 	 * Ctor initializes sam file path
 	 */ 
	Sam(std::string sam_fp);
	void read_sam(cmd_args args);

	/**
 	 * Reads sam file from stdin 
 	 */ 
	void read_from_stdin();

	/**
         * Reads sam file from directory or file path
         */	 
	void read_from_file(const std::string &sam_fp);

	/**
 	 *
 	 */	 
	void read_from_dir(const std::string &sam_dir_fp);

	std::vector<Alignments> alignment;

private:
	std::string _sam_fp;
};





#endif /* SAM_H */

