#include "Sam.h"
#include "alignment_util.h"

#include <string>
#include <vector>
#include <fstream>
#include <iostream>

Sam::Sam(std::string sam_fp) : _sam_fp(sam_fp) {}

void Sam::read_se_sam(const std::string &sam_fp, bool best) {
	std::ifstream in(sam_fp.c_str());
	if(!in) {
		std::cerr << "Could not open sam file " << sam_fp << std::endl;
		exit(EXIT_FAILURE);
	}

	std::string alignment;
	while(getline(in, alignment)) {
		if(alignment[0] == '@')
			continue;
		//std::vector<std::string> parts = split_alignment(alignment);
		if(se_fields_are_good(alignment, best)) {
			alignments.push_back(alignment);
		}
	}
	sort_by_qname(alignments);
}

void Sam::read_pe_sam(const std::string &sam_fp, bool best) {
	std::ifstream in(sam_fp.c_str());
	if(!in)	{
		std::cerr << "Could not open sam file " << sam_fp << std::endl;
		exit(EXIT_FAILURE);
	}

	std::string alignment;
	while(getline(in, alignment)) {
		if(alignment[0] == '@')
			continue;
		//std::vector<std::string> parts = split_alignment(alignment);
		if(pe_fields_are_good(alignment, best)) {
			alignments.push_back(alignment);
		}
	}
	sort_by_qname(alignments);
}

void Sam::sort_by_qname(std::vector<Alignment> &v) {
	sort(v.begin(), v.end(),
	     [](const Alignment &a, const Alignment &b)
	     { return a.qname() < b.qname(); });
}




