#ifndef ARGS_H
#define ARGS_H

#include <string>
#include <vector>

void static usage() {
        fprintf(stderr, "\n");
        fprintf(stderr, "Program: SNP Finder \n");
        fprintf(stderr, "Contact: Chris Dean <cdean11@rams.colostate.edu>\n\n");
        fprintf(stderr, "Usage: snp [options] <fasta_file> <sam_file> <best> <output_file>\n\n");
        fprintf(stderr, "Options:\n\n");
        fprintf(stderr, "   -amr_fp STRING             amr database\n");
        fprintf(stderr, "   -samse STRING           single-end alignments\n");
        fprintf(stderr, "   -sampe STRING           paired-end alignments\n");
        fprintf(stderr, "   -b BOOLEAN              filter on unique alignments\n");
        fprintf(stderr, "   -out_fp STRING               output path or(file)\n\n");
}

struct cmd_args {
	std::string amr_fp;
	std::string sam_fp;
	std::string out_fp;

	bool best = false;
	bool samse = false;
	bool sampe = false;
};

static inline cmd_args
parse_command_line(int argc, const char *argv[]) {
	std::vector<std::string> args(argv, argv+argc);
	
	cmd_args arg;

	for(int i = 1; i < argc; i++) {
		if(args[i] == "-amr_fp") {
			arg.amr_fp = args[++i];
		}
		else if(args[i] == "-samse") {
			arg.sam_fp = argv[++i];		
			arg.samse = true;
		}
		else if(args[i] == "-sampe") {
			arg.sam_fp = argv[++i];
			arg.sampe = true;
		}
		else if(args[i] == "-out_fp") {
			arg.out_fp = argv[++i];
		}
		else if(args[i] == "-b") {
			arg.best = true;		
		}
		else {
			usage();
			exit(EXIT_FAILURE);						
		}
	}
	return arg;
}

#endif //ARGS_H
