#include "Fasta.h"

#include <iostream>
#include <fstream>
#include <vector>
#include <string>

Fasta::Fasta(std::string amr_fp) : _amr_fp(amr_fp) {}

void Fasta::read_fasta(const std::string &amr_fp) {
	std::ifstream in(amr_fp.c_str());
	if(!in) {
		std::cerr << "Could not open fasta file " << amr_fp << std::endl;
		exit(EXIT_FAILURE);
	}

	std::string gene_id, gene, line;
	while(std::getline(in, line)) {
		std::size_t gene_idx = line.find(" ");
		
		if(gene_idx != std::string::npos)
			gene_id = line.substr(1, gene_idx-1);
		else
			gene_id = line.substr(1, line.length());

		std::getline(in, gene);
		records.push_back(FastaRecord(gene_id, gene));
	}
	in.close();
	
	FastaRecord::sort_by_gene_id(records);
}






