#ifndef ALIGNMENT_H
#define ALIGNMENT_H

#include <string>
#include <vector>
#include <algorithm>

struct bit_flag {
    /* SAM flags in English */
    bool read_paired =                              false;
    bool read_mapped_in_proper_pair =               false;
    bool read_unmapped =                            false;
    bool mate_unmapped =                            false;
    bool read_reverse_strand =                      false;
    bool mate_reverse_strand =                      false;
    bool first_in_pair =                            false;
    bool second_in_pair =                           false;
};

struct alignment_fields {
	std::string QNAME;
	int FLAG;
	std::string RNAME;
	int POS;
	std::string MAPQ;
	std::string CIGAR;
	std::string RNEXT;
	int PNEXT;
	int TLEN;
	std::string SEQ;
	std::string QUAL;
};

class Alignment {
public:
	Alignment(std::string alignment);
	void fill_alignment_fields(const std::string &alignment);
	void fill_bit_flag(const int &flag);
	bool fill_xa_field(const std::string &alignment);
	std::vector<std::pair<int,char> > get_cigar();

	inline std::string alignment() const	{ return _alignment; };
	inline std::string qname() const	{ return field.QNAME; };
	inline std::string rname() const	{ return field.RNAME; };
	inline std::string mapq() const		{ return field.MAPQ; };
	inline std::string cigar() const	{ return field.CIGAR; };
	inline std::string seq() const		{ return field.SEQ; };
	inline std::string rnext() const	{ return field.RNEXT; };
	inline int flag() const			{ return field.FLAG; };
	inline int pos() const			{ return field.POS; };
	inline int pnext() const		{ return field.PNEXT; };
	inline int tlen() const			{ return field.TLEN; };

    	inline bool read_paired() const                         { return b_flag.read_paired; };
    	inline bool read_mapped_in_proper_pair() const          { return b_flag.read_mapped_in_proper_pair; };
    	inline bool read_unmapped() const                       { return b_flag.read_unmapped; };
    	inline bool mate_unmapped() const                       { return b_flag.mate_unmapped; };
    	inline bool read_reverse_strand() const                 { return b_flag.read_reverse_strand; }
    	inline bool mate_reverse_strand() const                 { return b_flag.mate_reverse_strand; };
    	inline bool first_in_pair() const                       { return b_flag.first_in_pair; };
    	inline bool second_in_pair() const                      { return b_flag.second_in_pair; };

	inline void set_rname(std::string rname) {
		field.RNAME = rname;
	}
	inline void set_cigar(std::string cigar) {
		field.CIGAR = cigar;
	}
	inline void set_pos(int pos) {
		field.POS = pos;
	}

	struct xa_fields {
        	std::string rname;
        	std::string cigar;
        	int pos;
        	int edit;
	};

	std::vector<xa_fields> alternate_hits;
private:
	std::vector<std::pair<int,char> > get_cigar_operations(const std::string &cigar);

	std::string _alignment;

	alignment_fields field;

	bit_flag b_flag;
};

#endif // ALIGNMENT_H
