#include <algorithm>

#include "FastaRecord.h"

FastaRecord::FastaRecord(std::string gene_id, std::string gene) :
	_gene_id(gene_id), _gene(gene) {}

int FastaRecord::find_gene(const std::vector<FastaRecord> & records,
			   const std::string &gene_id,
			   const std::string seq) {
	int gene_index;
	
	std::vector<FastaRecord>::const_iterator low;
	low = std::lower_bound(records.begin(), records.end(),
			       FastaRecord(gene_id, seq),
			       [](const FastaRecord &a, const FastaRecord &b)
			       { return a.gene_id() < b.gene_id(); });
	gene_index = (low - records.begin());

	return gene_index;
}

void FastaRecord::sort_by_gene_id(std::vector<FastaRecord> &records) {
	sort(records.begin(), records.end(),
             [](const FastaRecord &a, const FastaRecord &b)
	     { return a.gene_id() < b.gene_id(); });
}
