#ifndef INT_UTIL_H
#define INT_UTIL_H

#include <string>
#include <sstream>

/**
 * Given a string, return its integer.
 */
static inline int
s_to_i(const std::string &s) {
	std::istringstream ss(s);
	int i;
	ss >> i;
	return i;
}

/**
 * Given an integer, return a random number
 * between 0 and i.
 */
static inline int
randomize(const int &i) {
	return rand() % i;
}

#endif /*INT_UTIL_H */


