#!/bin/sh

# Recovering special parameters from crac.xml
###############################################################
CRAC_BINARY=crac
INDEX_INPUT="$1"

# Getting the indexed genome value
###############################################################
# Getting the indexed Genome name without the extension
if [ -d "$INDEX_INPUT" ]; then				# If $INDEX_INPUT is a directory (that is to say an index from the history)
  cpt=0
  for fichier in $INDEX_INPUT/*.ssa
    do
      if [ $((++cpt)) -gt 1 ]; then 			#More than 1 '.ssa' file is not expected
        echo "Warning:Multiple indexes found [$INDEX]" >&2
      fi
    INDEX=${fichier%%.ssa}				#Getting the index from history
    done
  else
    INDEX="$INDEX_INPUT"				#Getting the prebuilt index
fi
if [ ! -f "$INDEX.ssa" -a ! -f "$INDEX.conf" ]; then	#Both '.ssa' and '.conf' files are required
  echo "Error:Index not found [$INDEX]" >&2
  exit 1
fi

# Execution of the command line (Submiting job to the cluster)
###############################################################
shift 2					#Avoiding index_input and output_name.extra_files_path

CRAC_CMD_LINE=""$CRAC_BINARY" -i "$INDEX" "$@""

out=`$CRAC_CMD_LINE`

exit 0

