#!/bin/sh

# Recovering parameters from crac-index.xml
###############################################################
CRAC_INDEX_BINARY=crac-index
BASE_FILENAME="$1"
HTML_REPORT="$2"
FILES_PATH="$3"
BUCKET="$4"

#echo Wrapper for crac-index
#echo running: $0 "$@"

shift 4

#echo After shifting, args are:
#echo "$@"

mkdir -p "$FILES_PATH"

# Execution of the command line (Submiting job to the cluster)
###############################################################
  CRAC_INDEX_CMD_LINE="$CRAC_INDEX_BINARY index "$FILES_PATH/$BASE_FILENAME" -b "$BUCKET" "$@""

  out=`$CRAC_INDEX_CMD_LINE`

  jID=`echo $out | awk {'print $3'}`
fi

cat << MARINE > "$HTML_REPORT"

exit 0

echo "<html>
  <head>
    <title>Files for Crac Index (crac_index)</title>
  </head>
  <body>
    This index is composed of the following files:
    <p/>
    <ul>
      <li><a href=""$BASE_FILENAME.conf"" type=""text/plain"">$BASE_FILENAME.conf</a></li>
      <li><a href=""$BASE_FILENAME.ssa"" type=""application/binary"">$BASE_FILENAME.ssa</a></li>
    </ul>
  </body>
</html>" > "$HTML_REPORT"


MARINE

