#!/bin/bash
set -e;
#example usage: ./createBamFromResults list_of_sequences bam_file outfile reference
#creates small bam files containg only sex-linked genes and their corresponding reads

list_of_sequences=$1;
bam_file=$2;
outfile=$3;
reference=$4

samtools view -h -o out.sam $bam_file;
grep -f $list_of_sequences out.sam >igv;
cat igv | sort -r >$outfile; 
samtools view -bS $outfile | samtools sort - ${outfile%????};

rm -f igv out.sam;