/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.protein;

import com.compomics.util.interfaces.Modification;
import com.compomics.util.protein.ModificationImplementation;
import com.compomics.util.protein.ModificationTemplate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ModificationFactory {
    static Logger logger = Logger.getLogger(ModificationFactory.class);
    private static final String RDBMS = "RDBMS";
    private static final String RDBDRIVER = "RDBDRIVER";
    private static final String TABLE = "TABLE";
    private static final String USER = "USER";
    private static final String PASSWORD = "PASSWORD";
    private static final String MODFILE = "MODFILE";
    private static final String CODEFILE = "CODEFILE";
    private static HashMap allMods = null;
    private static HashMap codeToTitle = null;
    private static HashMap titleToCode = null;
    private static boolean iInitialized = false;

    private ModificationFactory() {
    }

    public static Modification getModification(String aTitle, int aLocation) {
        ModificationImplementation mod = null;
        ModificationFactory.checkInit();
        if (allMods.containsKey(aTitle)) {
            ModificationTemplate template = (ModificationTemplate)allMods.get(aTitle);
            mod = new ModificationImplementation(template, aLocation);
        }
        return mod;
    }

    public static Modification getModification(String aCode, String aResidue, int aLocation) {
        ModificationImplementation mod = null;
        ModificationFactory.checkInit();
        for (String code : codeToTitle.keySet()) {
            Collection residues;
            String title;
            ModificationTemplate template;
            if (!code.startsWith(aCode) || code.length() - aCode.length() != 0 && code.length() - aCode.length() != 1 || (template = (ModificationTemplate)allMods.get(title = (String)codeToTitle.get(code))) == null || !(residues = template.getResidues()).contains(aResidue) || mod != null) continue;
            mod = new ModificationImplementation(template, aLocation);
        }
        return mod;
    }

    public static String modificationsToString() {
        StringBuffer sb = new StringBuffer();
        ModificationFactory.checkInit();
        Set keyset = allMods.keySet();
        Object[] keys = new String[allMods.size()];
        keyset.toArray(keys);
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            Object title = keys[i];
            ModificationTemplate template = (ModificationTemplate)allMods.get(title);
            boolean hidden = template.isArtifact();
            sb.append("Title:" + (String)title + "\n");
            if (hidden) {
                sb.append("Hidden\n");
            }
            keyset = (Set)template.getResidues();
            Object[] massKeys = new String[keyset.size()];
            keyset.toArray(massKeys);
            Arrays.sort(massKeys);
            for (int j = 0; j < massKeys.length; ++j) {
                Object residue = massKeys[j];
                if (((String)residue).equals("0")) {
                    sb.append("Nterm:");
                } else if (((String)residue).equals("1")) {
                    sb.append("Cterm:");
                } else {
                    sb.append("Residues:" + (String)residue);
                }
                sb.append(" " + template.getMonoisotopicMassDelta((String)residue) + " " + template.getAverageMassDelta((String)residue) + "\n");
            }
            sb.append("*\n");
        }
        return sb.toString();
    }

    public static String modificationConversionToString() {
        StringBuffer result = new StringBuffer();
        ModificationFactory.checkInit();
        Set keySet = titleToCode.keySet();
        Object[] titles = new String[keySet.size()];
        keySet.toArray(titles);
        Arrays.sort(titles);
        for (int i = 0; i < titles.length; ++i) {
            Object lTitle = titles[i];
            if (!allMods.containsKey(lTitle)) continue;
            result.append((String)lTitle + "=" + titleToCode.get(lTitle) + "\n");
        }
        return result.toString();
    }

    public static void reLoadAllData() {
        iInitialized = false;
        ModificationFactory.checkInit();
    }

    public static String[] getAllModificationTitles() {
        ModificationFactory.checkInit();
        String[] result = null;
        Set titles = allMods.keySet();
        result = new String[titles.size()];
        titles.toArray(result);
        return result;
    }

    private static void loadCodesFromFile(String aCodesFile) {
        codeToTitle = new HashMap();
        titleToCode = new HashMap();
        try {
            InputStream in = null;
            File temp = new File(aCodesFile);
            if (!temp.exists()) {
                in = ModificationFactory.class.getClassLoader().getResourceAsStream(aCodesFile);
                if (in == null) {
                    throw new IOException("Unable to load '" + aCodesFile + "' as an absolute path as well as from the classpath! Please check the filename!!");
                }
            } else {
                in = new FileInputStream(temp);
            }
            InputStreamReader is = new InputStreamReader(in);
            BufferedReader br = new BufferedReader(is);
            String line = null;
            HashMap<String, Integer> duplicateCodes = new HashMap<String, Integer>();
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.startsWith("!") || line.equals("")) continue;
                int location = line.indexOf("=");
                String title = line.substring(0, location).trim();
                String code = line.substring(location + 1).trim();
                String previous = titleToCode.put(title, code);
                if (duplicateCodes.containsKey(code)) {
                    int count = (Integer)duplicateCodes.get(code);
                    codeToTitle.put(code + ++count, title);
                    duplicateCodes.put(code, new Integer(count));
                    continue;
                }
                previous = codeToTitle.put(code, title);
                if (previous == null) continue;
                duplicateCodes.put(code, new Integer(1));
                codeToTitle.put(code + "0", previous);
                codeToTitle.put(code + "1", title);
                codeToTitle.remove(code);
            }
            if (in != null) {
                in.close();
            }
            is.close();
            br.close();
        }
        catch (IOException ioe) {
            logger.error((Object)ioe.getMessage(), (Throwable)ioe);
        }
    }

    private static void loadModificationsFromFile(String aModsFile) {
        allMods = new HashMap();
        try {
            InputStream in = null;
            File temp = new File(aModsFile);
            if (!temp.exists()) {
                in = ModificationFactory.class.getClassLoader().getResourceAsStream(aModsFile);
                if (in == null) {
                    throw new IOException("Unable to load '" + aModsFile + "' as an absolute path as well as from the classpath! Please check the filename!!");
                }
            } else {
                in = new FileInputStream(temp);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while ((line = br.readLine()) != null) {
                String residue;
                if (!(line = line.trim()).startsWith("Title:")) continue;
                String title = line.substring(6);
                line = br.readLine().trim();
                boolean hidden = false;
                HashMap<String, double[]> massDeltas = new HashMap<String, double[]>();
                if (line.equals("Hidden")) {
                    hidden = true;
                    line = br.readLine();
                }
                if (line.startsWith("Nterm:")) {
                    residue = "0";
                    massDeltas.put(residue, ModificationFactory.parseMonoAndAverageMassDelta(line.substring(6)));
                } else if (line.startsWith("Cterm:")) {
                    residue = "1";
                    massDeltas.put(residue, ModificationFactory.parseMonoAndAverageMassDelta(line.substring(6)));
                } else if (line.startsWith("Residues")) {
                    while (line.startsWith("Residues")) {
                        int colon = line.indexOf(":");
                        int first = line.indexOf(" ");
                        String residue2 = line.substring(colon + 1, first).trim();
                        massDeltas.put(residue2, ModificationFactory.parseMonoAndAverageMassDelta(line.substring(first + 1)));
                        line = br.readLine();
                    }
                }
                allMods.put(title, new ModificationTemplate(title, (String)titleToCode.get(title), massDeltas, hidden));
            }
            br.close();
            in.close();
        }
        catch (IOException ioe) {
            logger.error((Object)ioe.getMessage(), (Throwable)ioe);
        }
    }

    private static double[] parseMonoAndAverageMassDelta(String aData) {
        int spaceLocation = aData.indexOf(" ");
        double mono = Double.parseDouble(aData.substring(0, spaceLocation).trim());
        double avg = Double.parseDouble(aData.substring(spaceLocation).trim());
        return new double[]{mono, avg};
    }

    private static void loadAllFromFiles(String aModsFile, String aCodesFile) {
        ModificationFactory.loadCodesFromFile(aCodesFile);
        ModificationFactory.loadModificationsFromFile(aModsFile);
    }

    private static void loadAllFromRDBMS(String aDB, String aDriver, String aTable, Properties aConnectionProps) throws IOException {
        block28: {
            Connection conn = null;
            Statement stat = null;
            ResultSet rs = null;
            try {
                Driver driver = null;
                try {
                    driver = (Driver)Class.forName(aDriver).newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    throw new SQLException("Unable to load driver '" + aDriver + "'! Are you sure it is in the classpath?");
                }
                catch (IllegalAccessException iae) {
                    throw new SQLException("The driver '" + aDriver + "' does not seem to have an accessible public constructor!");
                }
                catch (InstantiationException ie) {
                    throw new SQLException("The driver '" + aDriver + "' does not seem to have an accessible public constructor!");
                }
                if (driver != null) {
                    conn = driver.connect(aDB, aConnectionProps);
                    stat = conn.createStatement();
                    rs = stat.executeQuery("select title, code, artifact, monoisotopicmassdeltas, averagemassdeltas from " + aTable);
                    HashMap<String, Integer> duplicateCodes = new HashMap<String, Integer>();
                    allMods = new HashMap();
                    titleToCode = new HashMap();
                    codeToTitle = new HashMap();
                    while (rs.next()) {
                        String title = rs.getString(1).trim();
                        String code = rs.getString(2);
                        boolean artifact = rs.getBoolean(3);
                        String monoDeltas = rs.getString(4).trim();
                        String avgDeltas = rs.getString(5).trim();
                        HashMap massDeltas = ModificationFactory.parseDeltasFromRDBMSStrings(monoDeltas, avgDeltas);
                        allMods.put(title, new ModificationTemplate(title, code, massDeltas, artifact));
                        if (code == null) continue;
                        String found = titleToCode.put(title, code);
                        if (found != null) {
                            logger.error((Object)("Duplicate title for modification: " + found));
                        }
                        if (duplicateCodes.containsKey(code)) {
                            int count = (Integer)duplicateCodes.get(code);
                            codeToTitle.put(code + ++count, title);
                            duplicateCodes.put(code, new Integer(count));
                            continue;
                        }
                        String previous = codeToTitle.put(code, title);
                        if (previous == null) continue;
                        duplicateCodes.put(code, new Integer(1));
                        codeToTitle.put(code + "0", previous);
                        codeToTitle.put(code + "1", title);
                        codeToTitle.remove(code);
                    }
                    break block28;
                }
                throw new SQLException("Driver '" + aDriver + "' was not loaded correctly! Unfortunately, no further details are known.");
            }
            catch (SQLException sqle) {
                throw new IOException(sqle.getMessage());
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {}
                }
                if (stat != null) {
                    try {
                        stat.close();
                    }
                    catch (Exception e) {}
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private static HashMap parseDeltasFromRDBMSStrings(String aMonoDeltas, String aAvgDeltas) throws IOException {
        String residue;
        int location;
        String resMassCombo;
        HashMap<String, Object> mappings = new HashMap<String, Object>();
        StringTokenizer st = new StringTokenizer(aMonoDeltas, ";");
        ArrayList<String> keys = new ArrayList<String>(10);
        while (st.hasMoreTokens()) {
            resMassCombo = st.nextToken();
            location = resMassCombo.lastIndexOf("_");
            if (location < 0) {
                throw new IOException("The content of the monoisotopicmassdeltas row could not be parsed from (a String + '_' + a double) since the '_' is missing!");
            }
            residue = resMassCombo.substring(0, location);
            String stringMonoValue = resMassCombo.substring(location + 1);
            double mono = 0.0;
            try {
                mono = Double.parseDouble(stringMonoValue);
            }
            catch (NumberFormatException nfe) {
                throw new IOException("The content of the monoisotopicmassdeltas row could not be parsed from (a String + '_' + a double)!");
            }
            mappings.put(residue, new Double(mono));
            keys.add(residue);
        }
        st = new StringTokenizer(aAvgDeltas, ";");
        while (st.hasMoreTokens()) {
            resMassCombo = st.nextToken();
            location = resMassCombo.lastIndexOf("_");
            if (location < 0) {
                throw new IOException("The content of the averagemassdeltas row could not be parsed from (a String + '_' + a double) since the '_' is missing!");
            }
            residue = resMassCombo.substring(0, location);
            String stringAvgValue = resMassCombo.substring(location + 1);
            double avg = 0.0;
            try {
                avg = Double.parseDouble(stringAvgValue);
            }
            catch (NumberFormatException nfe) {
                throw new IOException("The content of the averagemassdeltas row could not be parsed from (a String + '_' + a double)!");
            }
            Object temp = mappings.get(residue);
            if (temp == null) {
                throw new IOException("Residue '" + residue + "' was only present in the average mass delta mappings and NOT in the monoisotopic ones!");
            }
            double mono = (Double)temp;
            mappings.put(residue, new double[]{mono, avg});
            keys.remove(residue);
        }
        if (keys.size() > 0) {
            Iterator iter = keys.iterator();
            StringBuffer residues = new StringBuffer();
            while (iter.hasNext()) {
                residue = (String)iter.next();
                residues.append(residue + " ");
            }
            throw new IOException("The following residues all had a monoisotopic mass delta mapping, yet no average mass dleta mapping: " + residues.toString() + "!");
        }
        return mappings;
    }

    private static void checkInit() {
        if (!iInitialized) {
            InputStream is = ModificationFactory.class.getClassLoader().getResourceAsStream("ModificationFactory.properties");
            if (is == null) {
                ModificationFactory.loadAllFromFiles("modifications.txt", "modificationConversion.txt");
            } else {
                Properties props = new Properties();
                try {
                    props.load(is);
                    if (props.containsKey(RDBMS)) {
                        String db = props.getProperty(RDBMS);
                        String driver = props.getProperty(RDBDRIVER);
                        String table = props.getProperty(TABLE);
                        String user = props.getProperty(USER);
                        String password = props.getProperty(PASSWORD);
                        if (db == null || db.trim().equals("")) {
                            throw new IOException("RDBMS key defined  in 'ModificationFactory.properties', yet its value was 'null' or empty String!");
                        }
                        if (driver == null || driver.trim().equals("")) {
                            throw new IOException("RDBMS key defined  in 'ModificationFactory.properties', yet mandatory RDBDRIVER 'null' or empty String!");
                        }
                        if (table == null || table.trim().equals("")) {
                            throw new IOException("RDBMS key defined  in 'ModificationFactory.properties', yet mandatory TABLE 'null' or empty String!");
                        }
                        Properties dbProps = new Properties();
                        if (user != null && !user.trim().equals("")) {
                            if (password == null || password.trim().equals("")) {
                                throw new IOException("USER key defined  in 'ModificationFactory.properties', yet mandatory PASSWORD 'null' or empty String!");
                            }
                            dbProps.put("user", user.trim());
                            dbProps.put("username", user.trim());
                            dbProps.put("password", password.trim());
                        } else if (password != null && !password.trim().equals("")) {
                            throw new IOException("PASSWORD key defined  in 'ModificationFactory.properties', yet mandatory USER 'null' or empty String!");
                        }
                        ModificationFactory.loadAllFromRDBMS(db, driver, table, dbProps);
                    } else if (props.containsKey(MODFILE)) {
                        String mods = props.getProperty(MODFILE);
                        String codes = props.getProperty(CODEFILE);
                        if (mods == null || mods.trim().equals("")) {
                            throw new IOException("No RDBMS key defined in 'ModificationFactory.properties' and MODFILE was 'null' or empty String!");
                        }
                        if (codes == null || codes.trim().equals("")) {
                            throw new IOException("No RDBMS key defined in 'ModificationFactory.properties' and mandatory CODEFILE was 'null' or empty String!");
                        }
                        ModificationFactory.loadAllFromFiles(mods, codes);
                    }
                    iInitialized = true;
                }
                catch (IOException ioe) {
                    logger.error((Object)ioe.getMessage(), (Throwable)ioe);
                }
            }
        }
    }
}

