/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.protein;

import com.compomics.util.protein.AASequenceImpl;
import com.compomics.util.protein.Header;
import com.compomics.util.protein.Protein;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Enzyme
implements Cloneable {
    Logger logger = Logger.getLogger(Enzyme.class);
    public static final int CTERM = 0;
    public static final int NTERM = 1;
    public static final int FULLY_ENZYMATIC = 1;
    public static final int N_TERM_ENZYMATIC = 2;
    public static final int C_TERM_ENZYMATIC = 3;
    public static final int ENTIRELY_NOT_ENZYMATIC = 4;
    protected String iTitle = null;
    protected char[] iCleavage = null;
    protected HashMap iCleavables = null;
    protected char[] iRestrict = null;
    protected HashMap iRestrictors = null;
    protected int iPosition = -1;
    protected int iMiscleavages = 0;

    public Enzyme(String aTitle, String aCleavage, String aRestrict, String aPosition) {
        this(aTitle, aCleavage, aRestrict, aPosition, 1);
    }

    public Enzyme(String aTitle, String aCleavage, String aRestrict, String aPosition, int aMiscleavages) {
        this.iTitle = aTitle;
        this.setCleavage(aCleavage);
        this.setRestrict(aRestrict);
        aPosition = aPosition.trim();
        if (aPosition.equalsIgnoreCase("Cterm")) {
            this.iPosition = 0;
        } else if (aPosition.equalsIgnoreCase("Nterm")) {
            this.iPosition = 1;
        } else {
            throw new IllegalArgumentException("I only understand the positions 'Nterm' or 'Cterm'! You passed: '" + aPosition + "'.");
        }
        this.iMiscleavages = aMiscleavages;
    }

    public Enzyme(com.compomics.util.experiment.biology.Enzyme enzyme, int maxMissedCleavages) {
        String position = "";
        String cleavage = "";
        String restrict = "";
        if (enzyme.getAminoAcidBefore().size() > 0) {
            int i;
            position = "Cterm";
            ArrayList<Character> temp = enzyme.getAminoAcidBefore();
            for (i = 0; i < temp.size(); ++i) {
                cleavage = cleavage + temp.get(i);
            }
            temp = enzyme.getRestrictionAfter();
            for (i = 0; i < temp.size(); ++i) {
                restrict = restrict + temp.get(i);
            }
        } else {
            int i;
            position = "Nterm";
            ArrayList<Character> temp = enzyme.getAminoAcidAfter();
            for (i = 0; i < temp.size(); ++i) {
                cleavage = cleavage + temp.get(i);
            }
            temp = enzyme.getRestrictionBefore();
            for (i = 0; i < temp.size(); ++i) {
                restrict = restrict + temp.get(i);
            }
        }
        this.iTitle = enzyme.getName();
        this.setCleavage(cleavage);
        this.setRestrict(restrict);
        position = position.trim();
        if (position.equalsIgnoreCase("Cterm")) {
            this.iPosition = 0;
        } else if (position.equalsIgnoreCase("Nterm")) {
            this.iPosition = 1;
        } else {
            throw new IllegalArgumentException("I only understand the positions 'Nterm' or 'Cterm'! You passed: '" + position + "'.");
        }
        this.iMiscleavages = maxMissedCleavages;
    }

    public String getTitle() {
        return this.iTitle;
    }

    public void setTitle(String aTitle) {
        this.iTitle = aTitle;
    }

    public char[] getCleavage() {
        return this.iCleavage;
    }

    public void setCleavage(char[] aCleavage) {
        this.iCleavage = aCleavage;
        if (this.iCleavage != null) {
            this.iCleavables = new HashMap(this.iCleavage.length);
            for (int i = 0; i < this.iCleavage.length; ++i) {
                this.iCleavables.put(new Character(this.iCleavage[i]), "1");
            }
        } else {
            this.iCleavables = new HashMap();
        }
    }

    public void setCleavage(String aCleavage) {
        char[] temp = null;
        if (aCleavage != null) {
            temp = aCleavage.toUpperCase().toCharArray();
        }
        this.setCleavage(temp);
    }

    public char[] getRestrict() {
        return this.iRestrict;
    }

    public void setRestrict(char[] aRestrict) {
        this.iRestrict = aRestrict;
        if (this.iRestrict != null) {
            this.iRestrictors = new HashMap(this.iRestrict.length);
            for (int i = 0; i < this.iRestrict.length; ++i) {
                this.iRestrictors.put(new Character(this.iRestrict[i]), "1");
            }
        } else {
            this.iRestrictors = new HashMap();
        }
    }

    public void setRestrict(String aRestrict) {
        char[] temp = null;
        if (aRestrict != null) {
            temp = aRestrict.toUpperCase().toCharArray();
        }
        this.setRestrict(temp);
    }

    public int getPosition() {
        return this.iPosition;
    }

    public void setPosition(int aPosition) {
        this.iPosition = aPosition;
    }

    public int getMiscleavages() {
        return this.iMiscleavages;
    }

    public void setMiscleavages(int aMiscleavages) {
        this.iMiscleavages = aMiscleavages;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String aPrepend) {
        StringBuffer result = new StringBuffer("\n" + aPrepend + "Hi, I'm the Enzyme '" + this.iTitle + "'.\n");
        result.append(aPrepend + "I cleave at the sight of: '" + new String(this.iCleavage) + "'.\n");
        if (this.iRestrict != null) {
            result.append(aPrepend + "My activity is restricted by these residus: '" + new String(this.iRestrict) + "'.\n");
        } else {
            result.append(aPrepend + "There are no residus that restrict my activity.\n");
        }
        result.append(aPrepend + "My position is '" + (this.iPosition == 0 ? "C-terminal" : "N-terminal") + "'.\n");
        result.append(aPrepend + "I currently allow " + (this.iMiscleavages == 0 ? "no" : "up to " + this.iMiscleavages) + " missed cleavage" + (this.iMiscleavages == 1 ? "" : "s") + ".\n");
        return result.toString();
    }

    public Protein[] cleave(Protein aProtein) {
        return this.cleave(aProtein, 0, Integer.MAX_VALUE);
    }

    public Protein[] cleave(Protein aProtein, int minPeptideLength, int maxPeptideLength) {
        int start;
        String temp;
        Vector<Protein> result = null;
        Vector<Integer> startIndices = new Vector<Integer>(20, 10);
        Vector<Integer> endIndices = new Vector<Integer>(20, 10);
        Vector<String> interMed = new Vector<String>(20, 10);
        char[] sequence = aProtein.getSequence().getSequence().toCharArray();
        int headerStart = 0;
        if (aProtein.getHeader() != null && (headerStart = aProtein.getHeader().getStartLocation() - 1) < 0) {
            headerStart = 0;
        }
        int walkingIndex = 0;
        for (int i = 0; i < sequence.length; ++i) {
            Character next;
            Character current = new Character(sequence[i]);
            if (this.iCleavables.get(current) == null || i + 1 < sequence.length && this.iRestrictors.get(next = new Character(sequence[i + 1])) != null) continue;
            temp = null;
            start = -1;
            int end = -1;
            if (this.iPosition == 0) {
                temp = new String(sequence, walkingIndex, i - walkingIndex + 1);
                start = headerStart + walkingIndex + 1;
                end = headerStart + i + 1;
                walkingIndex = i + 1;
            } else if (this.iPosition == 1) {
                temp = new String(sequence, walkingIndex, i - walkingIndex);
                start = headerStart + walkingIndex + 1;
                end = headerStart + i;
                walkingIndex = i;
            }
            interMed.add(temp);
            startIndices.add(new Integer(start));
            endIndices.add(new Integer(end));
        }
        if (!(walkingIndex >= sequence.length || aProtein.isTruncated() && aProtein.getTruncationPosition() != 2)) {
            interMed.add(new String(sequence, walkingIndex, sequence.length - walkingIndex));
            startIndices.add(new Integer(headerStart + walkingIndex + 1));
            endIndices.add(new Integer(headerStart + sequence.length));
        }
        String[] imSequences = interMed.toArray(new String[interMed.size()]);
        for (int j = 0; j < imSequences.length; ++j) {
            temp = imSequences[j];
            for (int k = 0; k < this.iMiscleavages && j + k + 1 < imSequences.length; ++k) {
                temp = temp + imSequences[j + k + 1];
                interMed.add(temp);
                startIndices.add((Integer)startIndices.get(j));
                endIndices.add((Integer)endIndices.get(j + k + 1));
            }
        }
        if (aProtein.isTruncated() && aProtein.getTruncationPosition() == 2) {
            int parentStart = aProtein.getHeader().getStartLocation();
            if (parentStart < 0) {
                parentStart = 1;
            }
            for (int i = 0; i < interMed.size(); ++i) {
                start = (Integer)startIndices.get(i);
                if (start != parentStart) continue;
                startIndices.remove(i);
                endIndices.remove(i);
                interMed.remove(i);
                --i;
            }
        }
        int liSize = interMed.size();
        result = new Vector<Protein>(liSize);
        Header header = aProtein.getHeader();
        for (int i = 0; i < liSize; ++i) {
            String pepSequence = (String)interMed.get(i);
            if (pepSequence.indexOf("_") >= 0 || pepSequence.length() < minPeptideLength || pepSequence.length() > maxPeptideLength) continue;
            Header h = null;
            if (header != null) {
                h = (Header)header.clone();
                h.setLocation((Integer)startIndices.get(i), (Integer)endIndices.get(i));
            }
            result.add(new Protein(h, new AASequenceImpl(pepSequence)));
        }
        Protein[] finalResult = new Protein[result.size()];
        result.toArray(finalResult);
        return finalResult;
    }

    public Object clone() {
        Enzyme e = null;
        try {
            e = (Enzyme)super.clone();
            e.iCleavables = this.iCleavables;
            e.iCleavage = this.iCleavage;
            e.iMiscleavages = this.iMiscleavages;
            e.iPosition = this.iPosition;
            e.iRestrict = this.iRestrict;
            e.iRestrictors = this.iRestrictors;
            e.iTitle = this.iTitle;
        }
        catch (CloneNotSupportedException cnse) {
            this.logger.error((Object)cnse.getMessage(), (Throwable)cnse);
        }
        return e;
    }

    public int isEnzymaticProduct(String aParentSequence, String aSubSequence) {
        int start = aParentSequence.indexOf(aSubSequence);
        int end = start + aSubSequence.length();
        return this.isEnzymaticProduct(aParentSequence, start + 1, end);
    }

    public int isEnzymaticProduct(String aParentSequence, int aStart, int aEnd) {
        int result = 0;
        if (--aStart < 0 || --aEnd < 0) {
            throw new IllegalArgumentException("Subsequence is not a subsequence of the parent!");
        }
        if (aEnd > aParentSequence.length() - 1) {
            throw new IllegalArgumentException("Subsequence end index out of parent length range (" + aEnd + ">" + (aParentSequence.length() - 1) + ")!");
        }
        if (aStart > aEnd) {
            throw new IllegalArgumentException("Subsequence could not be retreived since start index is greater than end index (" + aStart + ">=" + aEnd + ")!");
        }
        int maxLength = aParentSequence.length();
        if (this.getPosition() == 0) {
            Character residue;
            if (aStart - 1 >= 0) {
                residue = new Character(aParentSequence.charAt(aStart - 1));
                Character possRestrict = new Character(aParentSequence.charAt(aStart));
                if (this.iCleavables.get(residue) != null && this.iRestrictors.get(possRestrict) == null) {
                    ++result;
                }
            } else {
                ++result;
            }
            residue = new Character(aParentSequence.charAt(aEnd));
            if (this.iCleavables.get(residue) != null || aEnd + 1 == maxLength) {
                if (aEnd + 1 < maxLength) {
                    if (this.iRestrictors.get(new Character(aParentSequence.charAt(aEnd + 1))) == null) {
                        result += 2;
                    }
                } else {
                    result += 2;
                }
            }
        } else {
            Character residue = new Character(aParentSequence.charAt(aStart));
            if (this.iCleavables.get(residue) != null) {
                if (aStart + 1 >= maxLength || this.iRestrictors.get(new Character(aParentSequence.charAt(aStart + 1))) == null) {
                    ++result;
                }
            } else if (aStart == 0) {
                ++result;
            }
            if (aEnd + 1 < maxLength) {
                Character residue2 = new Character(aParentSequence.charAt(aEnd + 1));
                if (this.iCleavables.get(residue2) != null) {
                    if (aEnd + 2 < maxLength) {
                        if (this.iRestrictors.get(new Character(aParentSequence.charAt(aEnd + 2))) == null) {
                            result += 2;
                        }
                    } else {
                        result += 2;
                    }
                }
            } else if (aEnd == maxLength - 1) {
                result += 2;
            }
        }
        switch (result) {
            case 0: {
                result = 4;
                break;
            }
            case 1: {
                result = 2;
                break;
            }
            case 2: {
                result = 3;
                break;
            }
            case 3: {
                result = 1;
                break;
            }
            default: {
                throw new RuntimeException("A number larger than 3 has been calculated for the 'enzymaticness' of a peptide.");
            }
        }
        return result;
    }
}

